/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.math3.ml.clustering.KMeansPlusPlusClusterer;
import org.apache.commons.math3.ml.clustering.MultiKMeansPlusPlusClusterer;
import org.apache.solr.client.solrj.io.eval.KmeansEvaluator;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class MultiKmeansEvaluator
extends RecursiveObjectEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;
    private int maxIterations = 1000;

    public MultiKmeansEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        for (StreamExpressionNamedParameter namedParam : namedParams) {
            if (namedParam.getName().equals("maxIterations")) {
                this.maxIterations = Integer.parseInt(namedParam.getParameter().toString().trim());
                continue;
            }
            throw new IOException("Unexpected named parameter:" + namedParam.getName());
        }
    }

    @Override
    public Object doWork(Object ... values2) throws IOException {
        if (values2.length != 3) {
            throw new IOException("The multiKmeans function expects three parameters; a matrix to cluster, k and number of trials.");
        }
        Object value1 = values2[0];
        Object value2 = values2[1];
        Object value3 = values2[2];
        Matrix matrix = null;
        int k = 0;
        int trials = 0;
        if (!(value1 instanceof Matrix)) {
            throw new IOException("The first parameter for multiKmeans should be the observation matrix.");
        }
        matrix = (Matrix)value1;
        if (!(value2 instanceof Number)) {
            throw new IOException("The second parameter for multiKmeans should be k.");
        }
        k = ((Number)value2).intValue();
        if (!(value3 instanceof Number)) {
            throw new IOException("The third parameter for multiKmeans should be trials.");
        }
        trials = ((Number)value3).intValue();
        KMeansPlusPlusClusterer kmeans = new KMeansPlusPlusClusterer(k, this.maxIterations);
        MultiKMeansPlusPlusClusterer multiKmeans = new MultiKMeansPlusPlusClusterer(kmeans, trials);
        ArrayList<KmeansEvaluator.ClusterPoint> points = new ArrayList<KmeansEvaluator.ClusterPoint>();
        double[][] data2 = matrix.getData();
        List<String> ids = matrix.getRowLabels();
        for (int i = 0; i < data2.length; ++i) {
            double[] vec = data2[i];
            points.add(new KmeansEvaluator.ClusterPoint(ids.get(i), vec));
        }
        HashMap<String, Object> fields2 = new HashMap<String, Object>();
        fields2.put("k", k);
        fields2.put("trials", trials);
        fields2.put("distance", "euclidean");
        fields2.put("maxIterations", this.maxIterations);
        return new KmeansEvaluator.ClusterTuple(fields2, multiKmeans.cluster(points), matrix.getColumnLabels());
    }
}

