/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class MinMaxScaleEvaluator
extends RecursiveObjectEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public MinMaxScaleEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object ... values2) throws IOException {
        if (null == values2) {
            return null;
        }
        double min = 0.0;
        double max = 1.0;
        if (values2.length == 3) {
            min = ((Number)values2[1]).doubleValue();
            max = ((Number)values2[2]).doubleValue();
        }
        if (values2[0] instanceof Matrix) {
            Matrix matrix = (Matrix)values2[0];
            double[][] data2 = matrix.getData();
            double[][] scaled = new double[data2.length][];
            for (int i = 0; i < scaled.length; ++i) {
                double[] row = data2[i];
                scaled[i] = MinMaxScaleEvaluator.scale(row, min, max);
            }
            return new Matrix(scaled);
        }
        if (values2[0] instanceof List) {
            List vec = (List)values2[0];
            double[] data3 = new double[vec.size()];
            for (int i = 0; i < vec.size(); ++i) {
                data3[i] = ((Number)vec.get(i)).doubleValue();
            }
            data3 = MinMaxScaleEvaluator.scale(data3, min, max);
            ArrayList<Double> scaled = new ArrayList<Double>(data3.length);
            for (double d : data3) {
                scaled.add(d);
            }
            return scaled;
        }
        throw new IOException();
    }

    public static double[] scale(double[] values2, double min, double max) {
        double localMin = Double.MAX_VALUE;
        double localMax = Double.MIN_VALUE;
        for (double d : values2) {
            if (d > localMax) {
                localMax = d;
            }
            if (!(d < localMin)) continue;
            localMin = d;
        }
        double[] scaled = new double[values2.length];
        for (int i = 0; i < scaled.length; ++i) {
            double s;
            double x = values2[i];
            scaled[i] = s = (x - localMin) / (localMax - localMin);
        }
        if (min != 0.0 || max != 1.0) {
            double scale = max - min;
            for (int i = 0; i < scaled.length; ++i) {
                double d = scaled[i];
                scaled[i] = scale * d + min;
            }
        }
        return scaled;
    }
}

