/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.RecursiveEvaluator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class MemsetEvaluator
extends RecursiveEvaluator {
    protected static final long serialVersionUID = 1L;
    private TupleStream in;
    private String[] cols;
    private String[] vars;
    private int size = -1;

    public MemsetEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, TupleStream.class);
        StreamExpressionNamedParameter colsExpression = factory.getNamedOperand(expression, "cols");
        StreamExpressionNamedParameter varsExpression = factory.getNamedOperand(expression, "vars");
        StreamExpressionNamedParameter sizeExpression = factory.getNamedOperand(expression, "size");
        if (1 != streamExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a single stream but found %d", expression, streamExpressions.size()));
        }
        if (null == colsExpression || !(colsExpression.getParameter() instanceof StreamExpressionValue)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting single 'cols' parameter listing fields to sort over but didn't find one", expression));
        }
        if (null == varsExpression || !(varsExpression.getParameter() instanceof StreamExpressionValue)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting single 'vars' parameter listing fields to sort over but didn't find one", expression));
        }
        if (null != sizeExpression) {
            StreamExpressionValue sizeExpressionValue = (StreamExpressionValue)sizeExpression.getParameter();
            String sizeString = sizeExpressionValue.getValue();
            this.size = Integer.parseInt(sizeString);
        }
        this.in = factory.constructStream(streamExpressions.get(0));
        StreamExpressionValue colsExpressionValue = (StreamExpressionValue)colsExpression.getParameter();
        StreamExpressionValue varsExpressionValue = (StreamExpressionValue)varsExpression.getParameter();
        String colsString = colsExpressionValue.getValue();
        String varsString = varsExpressionValue.getValue();
        this.vars = varsString.split(",");
        this.cols = colsString.split(",");
        if (this.cols.length != this.vars.length) {
            throw new IOException("The cols and vars lists must be the same size");
        }
        for (int i = 0; i < this.cols.length; ++i) {
            this.cols[i] = this.cols[i].trim();
            this.vars[i] = this.vars[i].trim();
        }
    }

    public MemsetEvaluator(StreamExpression expression, StreamFactory factory, List<String> ignoredNamedParameters) throws IOException {
        super(expression, factory, ignoredNamedParameters);
    }

    @Override
    public void setStreamContext(StreamContext streamContext) {
        this.streamContext = streamContext;
    }

    @Override
    public Object evaluate(Tuple tuple) throws IOException {
        try {
            this.in.setStreamContext(this.streamContext);
            this.in.open();
            HashMap arrays = new HashMap();
            for (String var : this.vars) {
                if (this.size > -1) {
                    arrays.put(var, new ArrayList(this.size));
                    continue;
                }
                arrays.put(var, new ArrayList());
            }
            int count = 0;
            while (true) {
                Tuple t = this.in.read();
                if (t.EOF) break;
                if (this.size == -1 || count < this.size) {
                    for (int i = 0; i < this.cols.length; ++i) {
                        String col = this.cols[i];
                        String var = this.vars[i];
                        List array = (List)arrays.get(var);
                        Number number = (Number)t.get(col);
                        array.add(number);
                    }
                }
                ++count;
            }
            HashMap hashMap = arrays;
            return hashMap;
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
        finally {
            this.in.close();
        }
    }

    @Override
    public Object doWork(Object ... values2) throws IOException {
        throw new IOException("This call should never occur");
    }
}

