/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveBooleanEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class MatchesEvaluator
extends RecursiveBooleanEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;
    private Pattern pattern;

    public MatchesEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (this.containedEvaluators.size() != 2) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting two parameters but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object ... values2) throws IOException {
        if (values2[1] instanceof String) {
            String s = values2[0].toString();
            if (this.pattern == null) {
                String p = (String)values2[1];
                this.pattern = Pattern.compile(p.replace("\"", ""));
            }
            if (s.startsWith("\"")) {
                s = s.replace("\"", "");
            }
            Matcher matcher = this.pattern.matcher(s);
            return matcher.find();
        }
        throw new IOException("The matches function requires a String regex");
    }

    @Override
    protected RecursiveBooleanEvaluator.Checker constructChecker(Object value) throws IOException {
        return null;
    }
}

