/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class ListCacheEvaluator
extends RecursiveObjectEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public ListCacheEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (this.containedEvaluators.size() > 1) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting at most 1 values but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object ... values2) throws IOException {
        ConcurrentMap<String, ConcurrentMap<String, Object>> objectCache = this.streamContext.getObjectCache();
        if (values2.length == 0) {
            return new ArrayList(objectCache.keySet());
        }
        if (values2.length == 1) {
            String space = (String)values2[0];
            Map spaceCache = (Map)objectCache.get(space = space.replace("\"", ""));
            if (spaceCache != null) {
                return new ArrayList(spaceCache.keySet());
            }
            return Collections.emptyList();
        }
        throw new IOException("The listCache function requires two parameters: workspace and key");
    }
}

