/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.Locale;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveBooleanEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class IsNullEvaluator
extends RecursiveBooleanEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public IsNullEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (this.containedEvaluators.size() != 1) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting one parameter but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object ... values2) throws IOException {
        String nullField;
        if (values2[0] == null) {
            return true;
        }
        if (values2[0] instanceof String && (nullField = this.getStreamContext().getTupleContext().get("null")) != null && nullField.equals(values2[0])) {
            return true;
        }
        return false;
    }

    @Override
    protected RecursiveBooleanEvaluator.Checker constructChecker(Object value) throws IOException {
        return null;
    }
}

