/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.transform.DftNormalization;
import org.apache.commons.math3.transform.FastFourierTransformer;
import org.apache.commons.math3.transform.TransformType;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.OneValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class IFFTEvaluator
extends RecursiveObjectEvaluator
implements OneValueWorker {
    protected static final long serialVersionUID = 1L;

    public IFFTEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (this.containedEvaluators.size() < 1) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting at least one value but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object v) throws IOException {
        if (v instanceof Matrix) {
            Matrix matrix = (Matrix)v;
            double[][] data2 = matrix.getData();
            double[] real = data2[0];
            double[] imaginary = data2[1];
            Complex[] complex = new Complex[real.length];
            for (int i = 0; i < real.length; ++i) {
                complex[i] = new Complex(real[i], imaginary[i]);
            }
            FastFourierTransformer fastFourierTransformer = new FastFourierTransformer(DftNormalization.STANDARD);
            Complex[] result2 = fastFourierTransformer.transform(complex, TransformType.INVERSE);
            ArrayList<Double> realResult = new ArrayList<Double>();
            for (int i = 0; i < result2.length; ++i) {
                realResult.add(result2[i].getReal());
            }
            return realResult;
        }
        throw new IOException("ifft function requires a matrix as a parameter");
    }
}

