/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.Locale;
import org.apache.commons.math3.geometry.Point;
import org.apache.commons.math3.geometry.enclosing.EnclosingBall;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.OneValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class GetSupportPointsEvaluator
extends RecursiveObjectEvaluator
implements OneValueWorker {
    private static final long serialVersionUID = 1L;

    public GetSupportPointsEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object value) throws IOException {
        if (!(value instanceof EnclosingBall)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for value, expecting an EnclosingBall", this.toExpression(this.constructingFactory), value.getClass().getSimpleName()));
        }
        EnclosingBall enclosingBall = (EnclosingBall)value;
        Point[] points = enclosingBall.getSupport();
        double[][] data2 = new double[points.length][2];
        int i = 0;
        for (Point point : points) {
            Vector2D eu = (Vector2D)point;
            data2[i][0] = eu.getX();
            data2[i][1] = eu.getY();
            ++i;
        }
        return new Matrix(data2);
    }
}

