/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.eval.TwoValueWorker;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class FeatureSelectEvaluator
extends RecursiveObjectEvaluator
implements TwoValueWorker {
    protected static final long serialVersionUID = 1L;

    public FeatureSelectEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (2 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting exactly 2 values but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object value1, Object value2) throws IOException {
        if (value1 instanceof Matrix) {
            Matrix matrix = (Matrix)value1;
            double[][] data2 = matrix.getData();
            List<String> labels = matrix.getColumnLabels();
            HashSet<String> features = new HashSet<String>();
            this.loadFeatures(value2, features);
            ArrayList<String> newColumnLabels = new ArrayList<String>();
            for (String label : labels) {
                if (!features.contains(label)) continue;
                newColumnLabels.add(label);
            }
            double[][] selectFeatures = new double[data2.length][newColumnLabels.size()];
            for (int i = 0; i < data2.length; ++i) {
                double[] currentRow = data2[i];
                double[] newRow = new double[newColumnLabels.size()];
                int index = -1;
                for (int l = 0; l < currentRow.length; ++l) {
                    String label = labels.get(l);
                    if (!features.contains(label)) continue;
                    newRow[++index] = currentRow[l];
                }
                selectFeatures[i] = newRow;
            }
            Matrix newMatrix = new Matrix(selectFeatures);
            newMatrix.setRowLabels(matrix.getRowLabels());
            newMatrix.setColumnLabels(newColumnLabels);
            return newMatrix;
        }
        throw new IOException("The featureSelect function expects a matrix as a parameter");
    }

    private void loadFeatures(Object o, Set<String> features) {
        List list = (List)o;
        for (Object v : list) {
            if (v instanceof List) {
                this.loadFeatures(v, features);
                continue;
            }
            features.add((String)v);
        }
    }
}

