/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveBooleanEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class ExclusiveOrEvaluator
extends RecursiveBooleanEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public ExclusiveOrEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (this.containedEvaluators.size() < 2) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting at least two values but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object ... values2) throws IOException {
        if (values2.length < 2) {
            String message = null;
            message = 1 == values2.length ? String.format(Locale.ROOT, "%s(...) only works with at least 2 values but 1 was provided", this.constructingFactory.getFunctionName(this.getClass())) : String.format(Locale.ROOT, "%s(...) only works with at least 2 values but 0 were provided", this.constructingFactory.getFunctionName(this.getClass()));
            throw new IOException(message);
        }
        RecursiveBooleanEvaluator.Checker checker = this.constructChecker(values2[0]);
        if (Arrays.stream(values2).anyMatch(result2 -> null == result2)) {
            throw new IOException(String.format(Locale.ROOT, "Unable to check %s(...) because a null value was found", this.constructingFactory.getFunctionName(this.getClass())));
        }
        if (Arrays.stream(values2).anyMatch(result2 -> !checker.isCorrectType(result2))) {
            throw new IOException(String.format(Locale.ROOT, "Unable to check %s(...) of differing types [%s]", this.constructingFactory.getFunctionName(this.getClass()), Arrays.stream(values2).map(item -> item.getClass().getSimpleName()).collect(Collectors.joining(","))));
        }
        return 1L == Arrays.stream(values2).filter(result2 -> (Boolean)result2).count();
    }

    @Override
    protected RecursiveBooleanEvaluator.Checker constructChecker(Object value) throws IOException {
        return new RecursiveBooleanEvaluator.BooleanChecker(){

            @Override
            public boolean test(Object left, Object right) {
                return false;
            }
        };
    }
}

