/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.commons.math3.random.EmpiricalDistribution;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluatorException;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class EmpiricalDistributionEvaluator
extends RecursiveNumericEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;
    private int bins = 99;

    public EmpiricalDistributionEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (2 != this.containedEvaluators.size() && 1 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting one or two values but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object ... values2) throws IOException {
        if (!(values2[0] instanceof List)) {
            throw new StreamEvaluatorException("List value expected but found type %s for value %s", values2[0].getClass().getName(), values2[0].toString());
        }
        if (values2.length == 2) {
            Number n = (Number)values2[1];
            this.bins = n.intValue();
        }
        EmpiricalDistribution empiricalDistribution = new EmpiricalDistribution(this.bins);
        double[] backingValues = ((List)values2[0]).stream().mapToDouble(innerValue -> ((Number)innerValue).doubleValue()).sorted().toArray();
        empiricalDistribution.load(backingValues);
        return empiricalDistribution;
    }
}

