/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.distance.EuclideanDistance;
import org.apache.solr.client.solrj.io.eval.CorrelationEvaluator;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class DistanceEvaluator
extends RecursiveObjectEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;
    private DistanceType type;

    public DistanceEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object ... values2) throws IOException {
        if (values2.length == 1) {
            if (values2[0] instanceof Matrix) {
                Matrix matrix = (Matrix)values2[0];
                EuclideanDistance euclideanDistance = new EuclideanDistance();
                return this.distance((DistanceMeasure)euclideanDistance, matrix);
            }
            throw new IOException("distance function operates on either two numeric arrays or a single matrix as parameters.");
        }
        if (values2.length == 2) {
            Object first = values2[0];
            Object second = values2[1];
            if (null == first) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the first value", this.toExpression(this.constructingFactory)));
            }
            if (null == second) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the second value", this.toExpression(this.constructingFactory)));
            }
            if (first instanceof Matrix) {
                Matrix matrix = (Matrix)first;
                DistanceMeasure distanceMeasure = (DistanceMeasure)second;
                return this.distance(distanceMeasure, matrix);
            }
            if (!(first instanceof List)) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the first value, expecting a list of numbers", this.toExpression(this.constructingFactory), first.getClass().getSimpleName()));
            }
            if (!(second instanceof List)) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the second value, expecting a list of numbers", this.toExpression(this.constructingFactory), first.getClass().getSimpleName()));
            }
            EuclideanDistance distanceMeasure = new EuclideanDistance();
            return distanceMeasure.compute(((List)first).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray(), ((List)second).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray());
        }
        if (values2.length == 3) {
            Object first = values2[0];
            Object second = values2[1];
            DistanceMeasure distanceMeasure = (DistanceMeasure)values2[2];
            if (null == first) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the first value", this.toExpression(this.constructingFactory)));
            }
            if (null == second) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the second value", this.toExpression(this.constructingFactory)));
            }
            if (!(first instanceof List)) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the first value, expecting a list of numbers", this.toExpression(this.constructingFactory), first.getClass().getSimpleName()));
            }
            if (!(second instanceof List)) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the second value, expecting a list of numbers", this.toExpression(this.constructingFactory), first.getClass().getSimpleName()));
            }
            return distanceMeasure.compute(((List)first).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray(), ((List)second).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray());
        }
        throw new IOException("distance function operates on either two numeric arrays or a single matrix as parameters.");
    }

    private Matrix distance(DistanceMeasure distanceMeasure, Matrix matrix) {
        double[][] data2 = matrix.getData();
        Array2DRowRealMatrix realMatrix = new Array2DRowRealMatrix(data2, false);
        realMatrix = (Array2DRowRealMatrix)realMatrix.transpose();
        data2 = realMatrix.getDataRef();
        double[][] distanceMatrix = new double[data2.length][data2.length];
        for (int i = 0; i < data2.length; ++i) {
            double[] row = data2[i];
            for (int j = 0; j < data2.length; ++j) {
                double dist;
                double[] row2 = data2[j];
                distanceMatrix[i][j] = dist = distanceMeasure.compute(row, row2);
            }
        }
        Matrix m = new Matrix(distanceMatrix);
        List<String> labels = CorrelationEvaluator.getColumnLabels(matrix.getColumnLabels(), data2.length);
        m.setColumnLabels(labels);
        m.setRowLabels(labels);
        return m;
    }

    public static enum DistanceType {
        euclidean,
        manhattan,
        canberra,
        earthMovers;

    }
}

