/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.List;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.correlation.Covariance;
import org.apache.solr.client.solrj.io.eval.CorrelationEvaluator;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class CovarianceEvaluator
extends RecursiveObjectEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public CovarianceEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object ... values2) throws IOException {
        if (values2.length == 2) {
            Object first = values2[0];
            Object second = values2[1];
            Covariance covariance = new Covariance();
            return covariance.covariance(((List)first).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray(), ((List)second).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray());
        }
        if (values2.length == 1) {
            Matrix matrix = (Matrix)values2[0];
            double[][] data2 = matrix.getData();
            Covariance covariance = new Covariance(data2, true);
            RealMatrix coMatrix = covariance.getCovarianceMatrix();
            double[][] coData = coMatrix.getData();
            Matrix realMatrix = new Matrix(coData);
            List<String> labels = CorrelationEvaluator.getColumnLabels(matrix.getColumnLabels(), coData.length);
            realMatrix.setColumnLabels(labels);
            realMatrix.setRowLabels(labels);
            return realMatrix;
        }
        throw new IOException("The cov function expects either two numeric arrays or a matrix as parameters.");
    }
}

