/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.correlation.KendallsCorrelation;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;
import org.apache.commons.math3.stat.correlation.SpearmansCorrelation;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.ZplotStream;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class CorrelationEvaluator
extends RecursiveObjectEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;
    private CorrelationType type;

    public CorrelationEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        if (namedParams.size() > 0) {
            if (namedParams.size() > 1) {
                throw new IOException("corr function expects only one named parameter 'type'.");
            }
            StreamExpressionNamedParameter namedParameter = namedParams.get(0);
            String name = namedParameter.getName();
            if (!name.equalsIgnoreCase("type")) {
                throw new IOException("corr function expects only one named parameter 'type'.");
            }
            String typeParam = namedParameter.getParameter().toString().trim();
            this.type = CorrelationType.valueOf(typeParam);
        } else {
            this.type = CorrelationType.pearsons;
        }
    }

    @Override
    public Object doWork(Object ... values2) throws IOException {
        if (values2.length == 2) {
            Object first = values2[0];
            Object second = values2[1];
            if (null == first) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the first value", this.toExpression(this.constructingFactory)));
            }
            if (null == second) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the second value", this.toExpression(this.constructingFactory)));
            }
            if (!(first instanceof List)) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the first value, expecting a list of numbers", this.toExpression(this.constructingFactory), first.getClass().getSimpleName()));
            }
            if (!(second instanceof List)) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the second value, expecting a list of numbers", this.toExpression(this.constructingFactory), first.getClass().getSimpleName()));
            }
            if (this.type.equals((Object)CorrelationType.pearsons)) {
                PearsonsCorrelation pearsonsCorrelation = new PearsonsCorrelation();
                return pearsonsCorrelation.correlation(((List)first).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray(), ((List)second).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray());
            }
            if (this.type.equals((Object)CorrelationType.kendalls)) {
                KendallsCorrelation kendallsCorrelation = new KendallsCorrelation();
                return kendallsCorrelation.correlation(((List)first).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray(), ((List)second).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray());
            }
            if (this.type.equals((Object)CorrelationType.spearmans)) {
                SpearmansCorrelation spearmansCorrelation = new SpearmansCorrelation();
                return spearmansCorrelation.correlation(((List)first).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray(), ((List)second).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray());
            }
            return null;
        }
        if (values2.length == 1) {
            if (values2[0] instanceof Matrix) {
                Matrix matrix = (Matrix)values2[0];
                double[][] data2 = matrix.getData();
                if (this.type.equals((Object)CorrelationType.pearsons)) {
                    PearsonsCorrelation pearsonsCorrelation = new PearsonsCorrelation(data2);
                    RealMatrix corrMatrix = pearsonsCorrelation.getCorrelationMatrix();
                    double[][] corrMatrixData = corrMatrix.getData();
                    Matrix realMatrix = new Matrix(corrMatrixData);
                    realMatrix.setAttribute("corr", pearsonsCorrelation);
                    List<String> labels = CorrelationEvaluator.getColumnLabels(matrix.getColumnLabels(), corrMatrixData.length);
                    realMatrix.setColumnLabels(labels);
                    realMatrix.setRowLabels(labels);
                    return realMatrix;
                }
                if (this.type.equals((Object)CorrelationType.kendalls)) {
                    KendallsCorrelation kendallsCorrelation = new KendallsCorrelation(data2);
                    RealMatrix corrMatrix = kendallsCorrelation.getCorrelationMatrix();
                    double[][] corrMatrixData = corrMatrix.getData();
                    Matrix realMatrix = new Matrix(corrMatrixData);
                    realMatrix.setAttribute("corr", kendallsCorrelation);
                    List<String> labels = CorrelationEvaluator.getColumnLabels(matrix.getColumnLabels(), corrMatrixData.length);
                    realMatrix.setColumnLabels(labels);
                    realMatrix.setRowLabels(labels);
                    return realMatrix;
                }
                if (this.type.equals((Object)CorrelationType.spearmans)) {
                    SpearmansCorrelation spearmansCorrelation = new SpearmansCorrelation((RealMatrix)new Array2DRowRealMatrix(data2, false));
                    RealMatrix corrMatrix = spearmansCorrelation.getCorrelationMatrix();
                    double[][] corrMatrixData = corrMatrix.getData();
                    Matrix realMatrix = new Matrix(corrMatrixData);
                    realMatrix.setAttribute("corr", spearmansCorrelation.getRankCorrelation());
                    List<String> labels = CorrelationEvaluator.getColumnLabels(matrix.getColumnLabels(), corrMatrixData.length);
                    realMatrix.setColumnLabels(labels);
                    realMatrix.setRowLabels(labels);
                    return realMatrix;
                }
                return null;
            }
            throw new IOException("corr function operates on either two numeric arrays or a single matrix as parameters.");
        }
        throw new IOException("corr function operates on either two numeric arrays or a single matrix as parameters.");
    }

    public static List<String> getColumnLabels(List<String> labels, int length) {
        if (labels != null) {
            return labels;
        }
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < length; ++i) {
            String label = "col" + ZplotStream.pad(Integer.toString(i), length);
            l.add(label);
        }
        return l;
    }

    public static enum CorrelationType {
        pearsons,
        kendalls,
        spearmans;

    }
}

