/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.Locale;
import org.apache.solr.client.solrj.io.eval.EvaluatorException;
import org.apache.solr.client.solrj.io.eval.FieldValueEvaluator;
import org.apache.solr.client.solrj.io.eval.OneValueWorker;
import org.apache.solr.client.solrj.io.eval.RawValueEvaluator;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class ConversionEvaluator
extends RecursiveNumericEvaluator
implements OneValueWorker {
    protected static final long serialVersionUID = 1L;
    private LENGTH_CONSTANT from;
    private LENGTH_CONSTANT to;
    private Converter converter;

    public ConversionEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (3 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting exactly 3 parameters but found %d", super.toExpression(this.constructingFactory), this.containedEvaluators.size()));
        }
        if (this.containedEvaluators.subList(0, 2).stream().anyMatch(item -> !(item instanceof RawValueEvaluator) && !(item instanceof FieldValueEvaluator))) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - first two parameters must be strings", super.toExpression(this.constructingFactory)));
        }
        String fromString = ((StreamEvaluator)this.containedEvaluators.get(0)).toExpression(factory).toString().toUpperCase(Locale.ROOT);
        String toString2 = ((StreamEvaluator)this.containedEvaluators.get(1)).toExpression(factory).toString().toUpperCase(Locale.ROOT);
        try {
            this.from = LENGTH_CONSTANT.valueOf(fromString);
            this.to = LENGTH_CONSTANT.valueOf(toString2);
            this.converter = this.constructConverter(this.from, this.to);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - '%s' and '%s' are not both valid conversion types", super.toExpression(this.constructingFactory), fromString, toString2));
        }
        this.containedEvaluators = this.containedEvaluators.subList(2, 3);
    }

    @Override
    public Object doWork(Object value) throws IOException {
        if (null == value) {
            return null;
        }
        return this.converter.convert(((Number)value).doubleValue());
    }

    private Converter constructConverter(LENGTH_CONSTANT from, LENGTH_CONSTANT to) throws IOException {
        switch (from) {
            case INCHES: {
                switch (to) {
                    case MILLIMETERS: {
                        return value -> value * 25.4;
                    }
                    case CENTIMETERS: {
                        return value -> value * 2.54;
                    }
                    case METERS: {
                        return value -> value * 0.0254;
                    }
                }
                throw new EvaluatorException(String.format(Locale.ROOT, "No conversion available from %s to %s", new Object[]{from, to}));
            }
            case FEET: {
                switch (to) {
                    case METERS: {
                        return value -> value * 0.3;
                    }
                }
                throw new EvaluatorException(String.format(Locale.ROOT, "No conversion available from %s to %s", new Object[]{from, to}));
            }
            case YARDS: {
                switch (to) {
                    case METERS: {
                        return value -> value * 0.91;
                    }
                    case KILOMETERS: {
                        return value -> value * 9.1E-4;
                    }
                }
                throw new EvaluatorException(String.format(Locale.ROOT, "No conversion available from %s to %s", new Object[]{from, to}));
            }
            case MILES: {
                switch (to) {
                    case KILOMETERS: {
                        return value -> value * 1.61;
                    }
                }
                throw new EvaluatorException(String.format(Locale.ROOT, "No conversion available from %s to %s", new Object[]{from, to}));
            }
            case MILLIMETERS: {
                switch (to) {
                    case INCHES: {
                        return value -> value * 0.039;
                    }
                }
                throw new EvaluatorException(String.format(Locale.ROOT, "No conversion available from %s to %s", new Object[]{from, to}));
            }
            case CENTIMETERS: {
                switch (to) {
                    case INCHES: {
                        return value -> value * 0.39;
                    }
                }
                throw new EvaluatorException(String.format(Locale.ROOT, "No conversion available from %s to %s", new Object[]{from, to}));
            }
            case METERS: {
                switch (to) {
                    case FEET: {
                        return value -> value * 3.28;
                    }
                }
                throw new EvaluatorException(String.format(Locale.ROOT, "No conversion available from %s to %s", new Object[]{from, to}));
            }
            case KILOMETERS: {
                switch (to) {
                    case MILES: {
                        return value -> value * 0.62;
                    }
                    case FEET: {
                        return value -> value * 3280.8;
                    }
                }
                throw new EvaluatorException(String.format(Locale.ROOT, "No conversion available from %s to %s", new Object[]{from, to}));
            }
        }
        throw new EvaluatorException(String.format(Locale.ROOT, "No conversion available from %s to %s", new Object[]{from, to}));
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(this.from.toString().toLowerCase(Locale.ROOT));
        expression.addParameter(this.to.toString().toLowerCase(Locale.ROOT));
        for (StreamEvaluator evaluator : this.containedEvaluators) {
            expression.addParameter(evaluator.toExpression(factory));
        }
        return expression;
    }

    static enum LENGTH_CONSTANT {
        MILES,
        YARDS,
        FEET,
        INCHES,
        MILLIMETERS,
        CENTIMETERS,
        METERS,
        KILOMETERS;

    }

    private static interface Converter {
        public double convert(double var1);
    }
}

