/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class ArrayEvaluator
extends RecursiveObjectEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;
    private Comparator<Comparable> sortComparator;

    public ArrayEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory, Arrays.asList("sort"));
        StreamExpressionNamedParameter sortParam = factory.getNamedOperand(expression, "sort");
        if (null != sortParam && sortParam.getParameter() instanceof StreamExpressionValue) {
            String sortOrder = ((StreamExpressionValue)sortParam.getParameter()).getValue().trim().toLowerCase(Locale.ROOT);
            if ("asc".equals(sortOrder) || "desc".equals(sortOrder)) {
                this.sortComparator = "asc".equals(sortOrder) ? (left, right) -> left.compareTo(right) : (left, right) -> right.compareTo(left);
            } else {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - invalid 'sort' parameter - expecting either 'asc' or 'desc'", expression));
            }
        }
    }

    @Override
    public Object doWork(Object ... values2) throws IOException {
        List newList = Arrays.stream(values2).collect(Collectors.toList());
        if (null != this.sortComparator) {
            for (Object value2 : newList) {
                if (value2 instanceof Comparable) continue;
                throw new IOException(String.format(Locale.ROOT, "Unable to evaluate because a non-Comparable value ('%s') was found and sorting was requested", value2.toString()));
            }
            newList = newList.stream().map(value -> (Comparable)value).sorted(this.sortComparator).collect(Collectors.toList());
        }
        return newList;
    }
}

