/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.common.EmptyEntityResolver;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.XMLErrorLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLResponseParser
extends ResponseParser {
    public static final String XML_CONTENT_TYPE = "application/xml; charset=UTF-8";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final XMLErrorLogger xmllog = new XMLErrorLogger(log);
    static final XMLInputFactory factory = XMLInputFactory.newInstance();

    @Override
    public String getWriterType() {
        return "xml";
    }

    @Override
    public String getContentType() {
        return XML_CONTENT_TYPE;
    }

    @Override
    public NamedList<Object> processResponse(Reader in) {
        XMLStreamReader parser = null;
        try {
            parser = factory.createXMLStreamReader(in);
        }
        catch (XMLStreamException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "parsing error", (Throwable)e);
        }
        return this.processResponse(parser);
    }

    @Override
    public NamedList<Object> processResponse(InputStream in, String encoding) {
        XMLStreamReader parser = null;
        try {
            parser = factory.createXMLStreamReader(in, encoding);
        }
        catch (XMLStreamException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "parsing error", (Throwable)e);
        }
        return this.processResponse(parser);
    }

    private NamedList<Object> processResponse(XMLStreamReader parser) {
        NamedList<Object> namedList;
        try {
            NamedList<Object> response = null;
            int event = parser.next();
            while (event != 8) {
                switch (event) {
                    case 1: {
                        if (response != null) {
                            throw new Exception("already read the response!");
                        }
                        String name = parser.getLocalName();
                        if (name.equals("response") || name.equals("result")) {
                            response = this.readNamedList(parser);
                            break;
                        }
                        if (name.equals("solr")) {
                            SimpleOrderedMap<Object> simpleOrderedMap = new SimpleOrderedMap<Object>();
                            return simpleOrderedMap;
                        }
                        throw new Exception("really needs to be response or result.  not:" + parser.getLocalName());
                    }
                }
                event = parser.next();
            }
            namedList = response;
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "parsing error", (Throwable)ex);
        }
        finally {
            try {
                parser.close();
            }
            catch (Exception exception) {}
        }
        return namedList;
    }

    protected NamedList<Object> readNamedList(XMLStreamReader parser) throws XMLStreamException {
        if (1 != parser.getEventType()) {
            throw new RuntimeException("must be start element, not: " + parser.getEventType());
        }
        StringBuilder builder = new StringBuilder();
        SimpleOrderedMap<Object> nl = new SimpleOrderedMap<Object>();
        KnownType type2 = null;
        String name = null;
        int depth = 0;
        while (true) {
            block0 : switch (parser.next()) {
                case 1: {
                    ++depth;
                    builder.setLength(0);
                    type2 = KnownType.get(parser.getLocalName());
                    if (type2 == null) {
                        throw new RuntimeException("this must be known type! not: " + parser.getLocalName());
                    }
                    name = null;
                    int cnt = parser.getAttributeCount();
                    for (int i = 0; i < cnt; ++i) {
                        if (!"name".equals(parser.getAttributeLocalName(i))) continue;
                        name = parser.getAttributeValue(i);
                        break;
                    }
                    if (type2.isLeaf) break;
                    switch (type2) {
                        case LST: {
                            nl.add(name, this.readNamedList(parser));
                            --depth;
                            break block0;
                        }
                        case ARR: {
                            nl.add(name, this.readArray(parser));
                            --depth;
                            break block0;
                        }
                        case RESULT: {
                            nl.add(name, this.readDocuments(parser));
                            --depth;
                            break block0;
                        }
                        case DOC: {
                            nl.add(name, this.readDocument(parser));
                            --depth;
                            break block0;
                        }
                        default: {
                            throw new XMLStreamException("branch element not handled!", parser.getLocation());
                        }
                    }
                }
                case 2: {
                    if (--depth < 0) {
                        return nl;
                    }
                    nl.add(name, type2.read(builder.toString().trim()));
                    break;
                }
                case 4: 
                case 6: 
                case 12: {
                    builder.append(parser.getText());
                }
            }
        }
    }

    protected List<Object> readArray(XMLStreamReader parser) throws XMLStreamException {
        if (1 != parser.getEventType()) {
            throw new RuntimeException("must be start element, not: " + parser.getEventType());
        }
        if (!"arr".equals(parser.getLocalName().toLowerCase(Locale.ROOT))) {
            throw new RuntimeException("must be 'arr', not: " + parser.getLocalName());
        }
        StringBuilder builder = new StringBuilder();
        KnownType type2 = null;
        ArrayList<Object> vals = new ArrayList<Object>();
        int depth = 0;
        while (true) {
            block0 : switch (parser.next()) {
                case 1: {
                    ++depth;
                    KnownType t = KnownType.get(parser.getLocalName());
                    if (t == null) {
                        throw new RuntimeException("this must be known type! not: " + parser.getLocalName());
                    }
                    if (type2 == null) {
                        type2 = t;
                    }
                    type2 = t;
                    builder.setLength(0);
                    if (type2.isLeaf) break;
                    switch (type2) {
                        case LST: {
                            vals.add(this.readNamedList(parser));
                            --depth;
                            break block0;
                        }
                        case ARR: {
                            vals.add(this.readArray(parser));
                            --depth;
                            break block0;
                        }
                        case RESULT: {
                            vals.add(this.readDocuments(parser));
                            --depth;
                            break block0;
                        }
                        case DOC: {
                            vals.add(this.readDocument(parser));
                            --depth;
                            break block0;
                        }
                        default: {
                            throw new XMLStreamException("branch element not handled!", parser.getLocation());
                        }
                    }
                }
                case 2: {
                    if (--depth < 0) {
                        return vals;
                    }
                    Object val = type2.read(builder.toString().trim());
                    if (val == null && type2 != KnownType.NULL) {
                        throw new XMLStreamException("error reading value:" + type2, parser.getLocation());
                    }
                    vals.add(val);
                    break;
                }
                case 4: 
                case 6: 
                case 12: {
                    builder.append(parser.getText());
                }
            }
        }
    }

    protected SolrDocumentList readDocuments(XMLStreamReader parser) throws XMLStreamException {
        SolrDocumentList docs = new SolrDocumentList();
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String n = parser.getAttributeLocalName(i);
            String v = parser.getAttributeValue(i);
            if ("numFound".equals(n)) {
                docs.setNumFound(Long.parseLong(v));
                continue;
            }
            if ("start".equals(n)) {
                docs.setStart(Long.parseLong(v));
                continue;
            }
            if (!"maxScore".equals(n)) continue;
            docs.setMaxScore(Float.valueOf(Float.parseFloat(v)));
        }
        while (true) {
            int event;
            if (1 == (event = parser.next())) {
                if (!"doc".equals(parser.getLocalName())) {
                    throw new RuntimeException("should be doc! " + parser.getLocalName() + " :: " + parser.getLocation());
                }
                docs.add(this.readDocument(parser));
                continue;
            }
            if (2 == event) break;
        }
        return docs;
    }

    protected SolrDocument readDocument(XMLStreamReader parser) throws XMLStreamException {
        if (1 != parser.getEventType()) {
            throw new RuntimeException("must be start element, not: " + parser.getEventType());
        }
        if (!"doc".equals(parser.getLocalName().toLowerCase(Locale.ROOT))) {
            throw new RuntimeException("must be 'lst', not: " + parser.getLocalName());
        }
        SolrDocument doc = new SolrDocument();
        StringBuilder builder = new StringBuilder();
        KnownType type2 = null;
        String name = null;
        int depth = 0;
        while (true) {
            switch (parser.next()) {
                case 1: {
                    ++depth;
                    builder.setLength(0);
                    type2 = KnownType.get(parser.getLocalName());
                    if (type2 == null) {
                        throw new RuntimeException("this must be known type! not: " + parser.getLocalName());
                    }
                    if (type2 == KnownType.DOC) {
                        doc.addChildDocument(this.readDocument(parser));
                        --depth;
                        break;
                    }
                    name = null;
                    int cnt = parser.getAttributeCount();
                    for (int i = 0; i < cnt; ++i) {
                        if (!"name".equals(parser.getAttributeLocalName(i))) continue;
                        name = parser.getAttributeValue(i);
                        break;
                    }
                    if (name == null) {
                        throw new XMLStreamException("requires 'name' attribute: " + parser.getLocalName(), parser.getLocation());
                    }
                    if (type2 == KnownType.ARR) {
                        for (Object val : this.readArray(parser)) {
                            doc.addField(name, val);
                        }
                        --depth;
                        break;
                    }
                    if (type2 == KnownType.LST) {
                        doc.addField(name, this.readNamedList(parser));
                        --depth;
                        break;
                    }
                    if (type2 == KnownType.RESULT) {
                        doc.put(name, (Object)this.readDocuments(parser));
                        --depth;
                        break;
                    }
                    if (type2 == KnownType.RAW) {
                        String raw = this.consumeRawContent(parser);
                        doc.addField(name, raw);
                        --depth;
                        break;
                    }
                    if (type2.isLeaf) break;
                    throw new XMLStreamException("must be value or array", parser.getLocation());
                }
                case 2: {
                    if (--depth < 0) {
                        return doc;
                    }
                    Object val = type2.read(builder.toString().trim());
                    if (val == null) {
                        throw new XMLStreamException("error reading value:" + type2, parser.getLocation());
                    }
                    doc.addField(name, val);
                    break;
                }
                case 4: 
                case 6: 
                case 12: {
                    builder.append(parser.getText());
                }
            }
        }
    }

    protected String consumeRawContent(XMLStreamReader parser) throws XMLStreamException {
        throw new UnsupportedOperationException(XMLResponseParser.class + " is not capable of consuming field values serialized as raw XML");
    }

    protected static String convertRawContent(String raw, Function<XMLStreamReader, String> consumeRawContent) throws XMLStreamException {
        XMLStreamReader subParser = factory.createXMLStreamReader(new StringReader("<raw>" + raw + "</raw>"));
        while (subParser.next() != 1) {
        }
        return consumeRawContent.apply(subParser);
    }

    static {
        EmptyEntityResolver.configureXMLInputFactory(factory);
        try {
            factory.setProperty("reuse-instance", Boolean.FALSE);
        }
        catch (IllegalArgumentException ex) {
            log.debug("Unable to set the 'reuse-instance' property for the input factory: {}", (Object)factory);
        }
        factory.setXMLReporter(xmllog);
    }

    protected static enum KnownType {
        STR(true){

            @Override
            public String read(String txt) {
                return txt;
            }
        }
        ,
        INT(true){

            @Override
            public Integer read(String txt) {
                return Integer.valueOf(txt);
            }
        }
        ,
        FLOAT(true){

            @Override
            public Float read(String txt) {
                return Float.valueOf(txt);
            }
        }
        ,
        DOUBLE(true){

            @Override
            public Double read(String txt) {
                return Double.valueOf(txt);
            }
        }
        ,
        LONG(true){

            @Override
            public Long read(String txt) {
                return Long.valueOf(txt);
            }
        }
        ,
        BOOL(true){

            @Override
            public Boolean read(String txt) {
                return Boolean.valueOf(txt);
            }
        }
        ,
        NULL(true){

            @Override
            public Object read(String txt) {
                return null;
            }
        }
        ,
        DATE(true){

            @Override
            public Date read(String txt) {
                try {
                    return new Date(Instant.parse(txt).toEpochMilli());
                }
                catch (Exception ex) {
                    if (log.isInfoEnabled()) {
                        log.info("Error reading date: {}", (Object)txt, (Object)ex);
                    }
                    return null;
                }
            }
        }
        ,
        RAW(true){

            @Override
            public Object read(String txt) {
                return null;
            }
        }
        ,
        ARR(false){

            @Override
            public Object read(String txt) {
                return null;
            }
        }
        ,
        LST(false){

            @Override
            public Object read(String txt) {
                return null;
            }
        }
        ,
        RESULT(false){

            @Override
            public Object read(String txt) {
                return null;
            }
        }
        ,
        DOC(false){

            @Override
            public Object read(String txt) {
                return null;
            }
        };

        final boolean isLeaf;

        private KnownType(boolean isLeaf) {
            this.isLeaf = isLeaf;
        }

        public abstract Object read(String var1);

        public static KnownType get(String v) {
            if (v != null) {
                try {
                    return KnownType.valueOf(v.toUpperCase(Locale.ROOT));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

