/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.cloud.NodeStateProvider;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.impl.CloudLegacySolrClient;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.ZkClientClusterStateProvider;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.client.solrj.response.SimpleSolrResponse;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.rule.ImplicitSnitch;
import org.apache.solr.common.cloud.rule.SnitchContext;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrClientNodeStateProvider
implements NodeStateProvider,
MapWriter {
    public static final String METRICS_PREFIX = "metrics:";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CloudLegacySolrClient solrClient;
    protected final Map<String, Map<String, Map<String, List<Replica>>>> nodeVsCollectionVsShardVsReplicaInfo = new HashMap<String, Map<String, Map<String, List<Replica>>>>();
    private Map<String, Object> snitchSession = new HashMap<String, Object>();
    private Map<String, Map> nodeVsTags = new HashMap<String, Map>();

    public SolrClientNodeStateProvider(CloudLegacySolrClient solrClient) {
        this.solrClient = solrClient;
        try {
            this.readReplicaDetails();
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    protected ClusterStateProvider getClusterStateProvider() {
        return this.solrClient.getClusterStateProvider();
    }

    protected void readReplicaDetails() throws IOException {
        ClusterStateProvider clusterStateProvider = this.getClusterStateProvider();
        ClusterState clusterState = clusterStateProvider.getClusterState();
        if (clusterState == null) {
            return;
        }
        Map<String, ClusterState.CollectionRef> all = clusterStateProvider.getClusterState().getCollectionStates();
        all.forEach((collName, ref) -> {
            DocCollection coll = ref.get();
            if (coll == null) {
                return;
            }
            coll.forEachReplica((shard, replica) -> {
                Map nodeData = this.nodeVsCollectionVsShardVsReplicaInfo.computeIfAbsent(replica.getNodeName(), k -> new HashMap());
                Map collData = nodeData.computeIfAbsent(collName, k -> new HashMap());
                List replicas = collData.computeIfAbsent(shard, k -> new ArrayList());
                replicas.add((Replica)replica.clone());
            });
        });
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        ew.put((CharSequence)"replicaInfo", Utils.getDeepCopy(this.nodeVsCollectionVsShardVsReplicaInfo, 5));
        ew.put((CharSequence)"nodeValues", this.nodeVsTags);
    }

    @Override
    public Map<String, Object> getNodeValues(String node, Collection<String> tags) {
        Map<String, Object> tagVals = this.fetchTagValues(node, tags);
        this.nodeVsTags.put(node, tagVals);
        return tagVals;
    }

    protected Map<String, Object> fetchTagValues(String node, Collection<String> tags) {
        MetricsFetchingSnitch snitch = new MetricsFetchingSnitch();
        ClientSnitchCtx ctx = new ClientSnitchCtx(null, node, this.snitchSession, this.solrClient);
        snitch.getTags(node, new HashSet<String>(tags), ctx);
        return ctx.getTags();
    }

    public void forEachReplica(String node, Consumer<Replica> consumer) {
        SolrClientNodeStateProvider.forEachReplica(this.nodeVsCollectionVsShardVsReplicaInfo.get(node), consumer);
    }

    public static void forEachReplica(Map<String, Map<String, List<Replica>>> collectionVsShardVsReplicas, Consumer<Replica> consumer) {
        collectionVsShardVsReplicas.forEach((coll, shardVsReplicas) -> shardVsReplicas.forEach((shard, replicaInfos) -> {
            for (int i = 0; i < replicaInfos.size(); ++i) {
                Replica r = (Replica)replicaInfos.get(i);
                consumer.accept(r);
            }
        }));
    }

    @Override
    public Map<String, Map<String, List<Replica>>> getReplicaInfo(String node, Collection<String> keys2) {
        Map result2 = this.nodeVsCollectionVsShardVsReplicaInfo.computeIfAbsent(node, o -> new HashMap());
        if (!keys2.isEmpty()) {
            HashMap<String, Pair<String, Replica>> metricsKeyVsTagReplica = new HashMap<String, Pair<String, Replica>>();
            SolrClientNodeStateProvider.forEachReplica(result2, r -> {
                for (String key : keys2) {
                    if (r.getProperties().containsKey(key)) continue;
                    String perReplicaMetricsKey = "solr.core." + r.getCollection() + "." + r.getShard() + "." + Utils.parseMetricsReplicaName(r.getCollection(), r.getCoreName()) + ":";
                    String perReplicaValue = key;
                    perReplicaMetricsKey = perReplicaMetricsKey + perReplicaValue;
                    metricsKeyVsTagReplica.put(perReplicaMetricsKey, new Pair<String, Replica>(key, (Replica)r));
                }
            });
            if (!metricsKeyVsTagReplica.isEmpty()) {
                Map<String, Object> tagValues = this.fetchReplicaMetrics(node, metricsKeyVsTagReplica);
                tagValues.forEach((k, o) -> {
                    Pair p = (Pair)metricsKeyVsTagReplica.get(k);
                    if (p.second() != null) {
                        ((Replica)p.second()).getProperties().put((String)p.first(), o);
                    }
                });
            }
        }
        return result2;
    }

    protected Map<String, Object> fetchReplicaMetrics(String node, Map<String, Pair<String, Replica>> metricsKeyVsTagReplica) {
        Map<String, Set<Object>> collect = metricsKeyVsTagReplica.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> Set.of(e.getKey())));
        ClientSnitchCtx ctx = new ClientSnitchCtx(null, null, Collections.emptyMap(), this.solrClient);
        SolrClientNodeStateProvider.fetchReplicaMetrics(node, ctx, collect);
        return ctx.getTags();
    }

    static void fetchReplicaMetrics(String solrNode, ClientSnitchCtx ctx, Map<String, Set<Object>> metricsKeyVsTag) {
        if (!ctx.isNodeAlive(solrNode)) {
            return;
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.add("key", metricsKeyVsTag.keySet().toArray(new String[0]));
        try {
            SimpleSolrResponse rsp = ctx.invokeWithRetry(solrNode, "/admin/metrics", params);
            metricsKeyVsTag.forEach((key, tags) -> {
                Object v = Utils.getObjectByPath(rsp.nl, true, Arrays.asList("metrics", key));
                for (Object tag : tags) {
                    if (tag instanceof Function) {
                        Pair p = (Pair)((Function)tag).apply(v);
                        ctx.getTags().put((String)p.first(), p.second());
                        continue;
                    }
                    if (v == null) continue;
                    ctx.getTags().put(tag.toString(), v);
                }
            });
        }
        catch (Exception e) {
            log.warn("could not get tags from node {}", (Object)solrNode, (Object)e);
        }
    }

    @Override
    public void close() throws IOException {
    }

    public String toString() {
        return Utils.toJSONString(this);
    }

    public static enum Variable {
        FREEDISK("freedisk", null, Double.class),
        TOTALDISK("totaldisk", null, Double.class),
        CORE_IDX("INDEX.sizeInGB", "INDEX.sizeInBytes", Double.class);

        public final String tagName;
        public final String metricsAttribute;
        public final Class<?> type;

        private Variable(String tagName, String metricsAttribute, Class<?> type2) {
            this.tagName = tagName;
            this.metricsAttribute = metricsAttribute;
            this.type = type2;
        }

        public Object convertVal(Object val) {
            if (val instanceof String) {
                return Double.valueOf((String)val);
            }
            if (val instanceof Number) {
                Number num = (Number)val;
                return num.doubleValue();
            }
            throw new IllegalArgumentException("Unknown type : " + val);
        }
    }

    static class ClientSnitchCtx
    extends SnitchContext {
        private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        ZkClientClusterStateProvider zkClientClusterStateProvider;
        CloudLegacySolrClient solrClient;

        public boolean isNodeAlive(String node) {
            if (this.zkClientClusterStateProvider != null) {
                return this.zkClientClusterStateProvider.getLiveNodes().contains(node);
            }
            return true;
        }

        public ClientSnitchCtx(SnitchContext.SnitchInfo perSnitch, String node, Map<String, Object> session, CloudLegacySolrClient solrClient) {
            super(perSnitch, node, session);
            this.solrClient = solrClient;
            this.zkClientClusterStateProvider = (ZkClientClusterStateProvider)solrClient.getClusterStateProvider();
        }

        @Override
        public Map<?, ?> getZkJson(String path) throws KeeperException, InterruptedException {
            try {
                byte[] bytes = this.zkClientClusterStateProvider.getZkStateReader().getZkClient().getData(path, null, null, true);
                if (bytes != null && bytes.length > 0) {
                    return (Map)Utils.fromJSON(bytes);
                }
            }
            catch (KeeperException.NoNodeException e) {
                return Collections.emptyMap();
            }
            return Collections.emptyMap();
        }

        public SimpleSolrResponse invokeWithRetry(String solrNode, String path, SolrParams params) throws InterruptedException, IOException, SolrServerException {
            int retries = 5;
            int cnt = 0;
            while (cnt++ < retries) {
                try {
                    return this.invoke(solrNode, path, params);
                }
                catch (IOException | SolrServerException | SolrException e) {
                    boolean hasIOExceptionCause = false;
                    for (Throwable t = e; t != null; t = t.getCause()) {
                        if (!(t instanceof IOException)) continue;
                        hasIOExceptionCause = true;
                        break;
                    }
                    if (hasIOExceptionCause) {
                        if (log.isInfoEnabled()) {
                            log.info("Error on getting remote info, trying again: ", e);
                        }
                        Thread.sleep(500L);
                        continue;
                    }
                    throw e;
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not get remote info after many retries on NoHttpResponseException");
        }

        public SimpleSolrResponse invoke(String solrNode, String path, SolrParams params) throws IOException, SolrServerException {
            String url = this.zkClientClusterStateProvider.getZkStateReader().getBaseUrlForNodeName(solrNode);
            GenericSolrRequest request = new GenericSolrRequest(SolrRequest.METHOD.POST, path, params);
            try (HttpSolrClient client = ((HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder().withHttpClient(this.solrClient.getHttpClient())).withBaseSolrUrl(url).withResponseParser(new BinaryResponseParser())).build();){
                NamedList<Object> rsp = client.request(request);
                request.response.nl = rsp;
                SimpleSolrResponse simpleSolrResponse = request.response;
                return simpleSolrResponse;
            }
        }
    }

    static class MetricsFetchingSnitch
    extends ImplicitSnitch {
        MetricsFetchingSnitch() {
        }

        @Override
        protected void getRemoteInfo(String solrNode, Set<String> requestedTags, SnitchContext ctx) {
            if (!((ClientSnitchCtx)ctx).isNodeAlive(solrNode)) {
                return;
            }
            ClientSnitchCtx snitchContext = (ClientSnitchCtx)ctx;
            HashMap<String, Set<Object>> metricsKeyVsTag = new HashMap<String, Set<Object>>();
            for (String tag : requestedTags) {
                if (tag.startsWith("sysprop.")) {
                    metricsKeyVsTag.computeIfAbsent("solr.jvm:system.properties:" + tag.substring("sysprop.".length()), k -> new HashSet()).add(tag);
                    continue;
                }
                if (!tag.startsWith(SolrClientNodeStateProvider.METRICS_PREFIX)) continue;
                metricsKeyVsTag.computeIfAbsent(tag.substring(SolrClientNodeStateProvider.METRICS_PREFIX.length()), k -> new HashSet()).add(tag);
            }
            if (!metricsKeyVsTag.isEmpty()) {
                SolrClientNodeStateProvider.fetchReplicaMetrics(solrNode, snitchContext, metricsKeyVsTag);
            }
            HashSet<String> groups2 = new HashSet<String>();
            ArrayList<String> prefixes = new ArrayList<String>();
            if (requestedTags.contains("freedisk")) {
                groups2.add("solr.node");
                prefixes.add("CONTAINER.fs.usableSpace");
            }
            if (requestedTags.contains(Variable.TOTALDISK.tagName)) {
                groups2.add("solr.node");
                prefixes.add("CONTAINER.fs.totalSpace");
            }
            if (requestedTags.contains("cores")) {
                groups2.add("solr.node");
                prefixes.add("CONTAINER.cores");
            }
            if (requestedTags.contains("sysLoadAvg")) {
                groups2.add("solr.jvm");
                prefixes.add("os.systemLoadAverage");
            }
            if (requestedTags.contains("heapUsage")) {
                groups2.add("solr.jvm");
                prefixes.add("memory.heap.usage");
            }
            if (groups2.isEmpty() || prefixes.isEmpty()) {
                return;
            }
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.add("group", StrUtils.join(groups2, ','));
            params.add("prefix", StrUtils.join(prefixes, ','));
            try {
                SimpleSolrResponse rsp = snitchContext.invokeWithRetry(solrNode, "/admin/metrics", params);
                NamedList metrics = (NamedList)rsp.nl.get("metrics");
                if (metrics != null) {
                    Object n;
                    if (requestedTags.contains(Variable.FREEDISK.tagName) && (n = Utils.getObjectByPath((Object)metrics, true, "solr.node/CONTAINER.fs.usableSpace")) != null) {
                        ctx.getTags().put(Variable.FREEDISK.tagName, Variable.FREEDISK.convertVal(n));
                    }
                    if (requestedTags.contains(Variable.TOTALDISK.tagName) && (n = Utils.getObjectByPath((Object)metrics, true, "solr.node/CONTAINER.fs.totalSpace")) != null) {
                        ctx.getTags().put(Variable.TOTALDISK.tagName, Variable.TOTALDISK.convertVal(n));
                    }
                    if (requestedTags.contains("cores")) {
                        NamedList node = (NamedList)metrics.get("solr.node");
                        int count = 0;
                        for (String leafCoreMetricName : new String[]{"lazy", "loaded", "unloaded"}) {
                            Number n2 = (Number)node.get("CONTAINER.cores." + leafCoreMetricName);
                            if (n2 == null) continue;
                            count += n2.intValue();
                        }
                        ctx.getTags().put("cores", count);
                    }
                    if (requestedTags.contains("sysLoadAvg") && (n = (Number)Utils.getObjectByPath((Object)metrics, true, "solr.jvm/os.systemLoadAverage")) != null) {
                        ctx.getTags().put("sysLoadAvg", ((Number)n).doubleValue());
                    }
                    if (requestedTags.contains("heapUsage") && (n = (Number)Utils.getObjectByPath((Object)metrics, true, "solr.jvm/memory.heap.usage")) != null) {
                        ctx.getTags().put("heapUsage", ((Number)n).doubleValue() * 100.0);
                    }
                }
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error getting remote info", (Throwable)e);
            }
        }
    }
}

