/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.SolrClientBuilder;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@Deprecated(since="9.0")
public class ConcurrentUpdateSolrClient
extends SolrClient {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private HttpSolrClient client;
    final BlockingQueue<Update> queue;
    final ExecutorService scheduler;
    final Queue<Runner> runners;
    volatile CountDownLatch lock = null;
    final int threadCount;
    boolean shutdownExecutor = false;
    int pollQueueTime = 250;
    int stallTime;
    private final boolean streamDeletes;
    private boolean internalHttpClient;
    private volatile Integer connectionTimeout;
    private volatile Integer soTimeout;
    private volatile boolean closed;
    AtomicInteger pollInterrupts;
    AtomicInteger pollExits;
    AtomicInteger blockLoops;
    AtomicInteger emptyQueueLoops;

    protected ConcurrentUpdateSolrClient(Builder builder) {
        this.internalHttpClient = builder.httpClient == null;
        this.client = ((HttpSolrClient.Builder)((HttpSolrClient.Builder)((HttpSolrClient.Builder)((HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder(builder.baseSolrUrl).withHttpClient(builder.httpClient)).withConnectionTimeout(builder.connectionTimeoutMillis, TimeUnit.MILLISECONDS)).withSocketTimeout(builder.socketTimeoutMillis, TimeUnit.MILLISECONDS)).withFollowRedirects(false)).withTheseParamNamesInTheUrl(builder.urlParamNames)).build();
        this.queue = new LinkedBlockingQueue<Update>(builder.queueSize);
        this.threadCount = builder.threadCount;
        this.runners = new ArrayDeque<Runner>();
        this.streamDeletes = builder.streamDeletes;
        this.connectionTimeout = Math.toIntExact(builder.connectionTimeoutMillis);
        this.soTimeout = Math.toIntExact(builder.socketTimeoutMillis);
        this.stallTime = Integer.getInteger("solr.cloud.client.stallTime", 15000);
        if (this.stallTime < this.pollQueueTime * 2) {
            throw new RuntimeException("Invalid stallTime: " + this.stallTime + "ms, must be 2x > pollQueueTime " + this.pollQueueTime);
        }
        this.setPollQueueTime(builder.pollQueueTime);
        if (builder.executorService != null) {
            this.scheduler = builder.executorService;
            this.shutdownExecutor = false;
        } else {
            this.scheduler = ExecutorUtil.newMDCAwareCachedThreadPool(new SolrNamedThreadFactory("concurrentUpdateScheduler"));
            this.shutdownExecutor = true;
        }
        if (log.isDebugEnabled()) {
            this.pollInterrupts = new AtomicInteger();
            this.pollExits = new AtomicInteger();
            this.blockLoops = new AtomicInteger();
            this.emptyQueueLoops = new AtomicInteger();
        }
    }

    @Deprecated
    public Set<String> getQueryParams() {
        return this.getUrlParamNames();
    }

    public Set<String> getUrlParamNames() {
        return this.client.getUrlParamNames();
    }

    @Deprecated
    public void setQueryParams(Set<String> queryParams) {
        this.client.setQueryParams(queryParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyQueueAndRunnersIfEmptyQueue() {
        if (this.queue.size() == 0) {
            Queue<Object> queue = this.queue;
            synchronized (queue) {
                this.queue.notifyAll();
            }
            queue = this.runners;
            synchronized (queue) {
                this.runners.notifyAll();
            }
        }
    }

    private void addRunner() {
        MDC.put("ConcurrentUpdateSolrClient.url", this.client.getBaseURL());
        try {
            Runner r = new Runner();
            this.runners.add(r);
            try {
                this.scheduler.execute(r);
            }
            catch (RuntimeException e) {
                this.runners.remove(r);
                throw e;
            }
        }
        finally {
            MDC.remove("ConcurrentUpdateSolrClient.url");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamedList<Object> request(SolrRequest<?> request, String collection) throws SolrServerException, IOException {
        block19: {
            ModifiableSolrParams params;
            if (!(request instanceof UpdateRequest)) {
                return this.client.request(request, collection);
            }
            UpdateRequest req = (UpdateRequest)request;
            if (this.streamDeletes) {
                if (!(req.getDocuments() != null && !req.getDocuments().isEmpty() || req.getDeleteById() != null && !req.getDeleteById().isEmpty() || req.getDeleteByIdMap() != null && !req.getDeleteByIdMap().isEmpty() || req.getDeleteQuery() != null)) {
                    this.blockUntilFinished();
                    return this.client.request(request, collection);
                }
            } else if (req.getDocuments() == null || req.getDocuments().isEmpty()) {
                this.blockUntilFinished();
                return this.client.request(request, collection);
            }
            if ((params = req.getParams()) != null && params.getBool("waitSearcher", false)) {
                log.info("blocking for commit/optimize");
                this.blockUntilFinished();
                return this.client.request(request, collection);
            }
            try {
                long currentStallTime;
                CountDownLatch tmpLock = this.lock;
                if (tmpLock != null) {
                    tmpLock.await();
                }
                Update update = new Update(req, collection);
                boolean success = this.queue.offer(update);
                long lastStallTime = -1L;
                int lastQueueSize = -1;
                while (true) {
                    Queue<Runner> queue = this.runners;
                    synchronized (queue) {
                        if (this.runners.isEmpty() || this.queue.remainingCapacity() < this.queue.size() && this.runners.size() < this.threadCount) {
                            this.addRunner();
                        } else if (success) {
                            break block19;
                        }
                    }
                    if (!success) {
                        success = this.queue.offer(update, 100L, TimeUnit.MILLISECONDS);
                    }
                    if (success) continue;
                    int currentQueueSize = this.queue.size();
                    if (currentQueueSize != lastQueueSize) {
                        lastQueueSize = currentQueueSize;
                        lastStallTime = -1L;
                        continue;
                    }
                    if (lastStallTime == -1L) {
                        lastStallTime = System.nanoTime();
                        continue;
                    }
                    currentStallTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - lastStallTime);
                    if (currentStallTime > (long)this.stallTime) break;
                }
                throw new IOException("Request processing has stalled for " + currentStallTime + "ms with " + this.queue.size() + " remaining elements in the queue.");
            }
            catch (InterruptedException e) {
                log.error("interrupted", e);
                throw new IOException(e.getLocalizedMessage());
            }
        }
        NamedList<Object> dummy = new NamedList<Object>();
        dummy.add("NOTE", "the request is processed in a background stream");
        return dummy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void blockUntilFinished() throws IOException {
        this.lock = new CountDownLatch(1);
        try {
            this.waitForEmptyQueue();
            this.interruptRunnerThreadsPolling();
            long lastStallTime = -1L;
            int lastQueueSize = -1;
            Queue<Runner> queue = this.runners;
            synchronized (queue) {
                int loopCount = 0;
                while (!this.runners.isEmpty()) {
                    if (log.isDebugEnabled()) {
                        this.blockLoops.incrementAndGet();
                    }
                    if (ExecutorUtil.isShutdown(this.scheduler)) break;
                    ++loopCount;
                    int queueSize = this.queue.size();
                    if (lastQueueSize != queueSize) {
                        lastQueueSize = queueSize;
                        lastStallTime = -1L;
                    } else if (lastStallTime == -1L) {
                        lastStallTime = System.nanoTime();
                    } else {
                        long currentStallTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - lastStallTime);
                        if (currentStallTime > (long)this.stallTime) {
                            throw new IOException("Task queue processing has stalled for " + currentStallTime + " ms with " + queueSize + " remaining elements to process.");
                        }
                    }
                    if (queueSize > 0 && this.runners.isEmpty()) {
                        log.warn("No more runners, but queue still has {} adding more runners to process remaining requests on queue", (Object)queueSize);
                        this.addRunner();
                    }
                    this.interruptRunnerThreadsPolling();
                    int timeout = loopCount < 3 ? 10 : (loopCount < 10 ? 25 : 250);
                    try {
                        this.runners.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        finally {
            this.lock.countDown();
            this.lock = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForEmptyQueue() throws IOException {
        boolean threadInterrupted = Thread.currentThread().isInterrupted();
        long lastStallTime = -1L;
        int lastQueueSize = -1;
        while (!this.queue.isEmpty()) {
            if (log.isDebugEnabled()) {
                this.emptyQueueLoops.incrementAndGet();
            }
            if (ExecutorUtil.isTerminated(this.scheduler)) {
                log.warn("The task queue still has elements but the update scheduler {} is terminated. Can't process any more tasks. Queue size: {}, Runners: {}. Current thread Interrupted? {}", this.scheduler, this.queue.size(), this.runners.size(), threadInterrupted);
                break;
            }
            Queue<Runner> queue = this.runners;
            synchronized (queue) {
                int queueSize = this.queue.size();
                if (queueSize > 0 && this.runners.isEmpty()) {
                    log.warn("No more runners, but queue still has {} adding more runners to process remaining requests on queue", (Object)queueSize);
                    this.addRunner();
                }
            }
            queue = this.queue;
            synchronized (queue) {
                try {
                    this.queue.wait(250L);
                }
                catch (InterruptedException e) {
                    threadInterrupted = true;
                    log.warn("Thread interrupted while waiting for update queue to be empty. There are still {} elements in the queue.", (Object)this.queue.size());
                }
            }
            int currentQueueSize = this.queue.size();
            if (currentQueueSize != lastQueueSize) {
                lastQueueSize = currentQueueSize;
                lastStallTime = -1L;
                continue;
            }
            lastQueueSize = currentQueueSize;
            if (lastStallTime == -1L) {
                lastStallTime = System.nanoTime();
                continue;
            }
            long currentStallTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - lastStallTime);
            if (currentStallTime <= (long)this.stallTime) continue;
            throw new IOException("Task queue processing has stalled for " + currentStallTime + " ms with " + currentQueueSize + " remaining elements to process.");
        }
        if (threadInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public void handleError(Throwable ex) {
        log.error("error", ex);
    }

    public void onSuccess(HttpResponse resp) {
    }

    @Override
    public synchronized void close() {
        block12: {
            if (this.closed) {
                this.interruptRunnerThreadsPolling();
                return;
            }
            this.closed = true;
            try {
                block11: {
                    if (this.shutdownExecutor) {
                        this.scheduler.shutdown();
                        this.interruptRunnerThreadsPolling();
                        try {
                            if (this.scheduler.awaitTermination(60L, TimeUnit.SECONDS)) break block11;
                            this.scheduler.shutdownNow();
                            if (!this.scheduler.awaitTermination(60L, TimeUnit.SECONDS)) {
                                log.error("ExecutorService did not terminate");
                            }
                        }
                        catch (InterruptedException ie) {
                            this.scheduler.shutdownNow();
                            Thread.currentThread().interrupt();
                        }
                    } else {
                        this.interruptRunnerThreadsPolling();
                    }
                }
                if (!this.internalHttpClient) break block12;
            }
            catch (Throwable throwable) {
                if (this.internalHttpClient) {
                    IOUtils.closeQuietly(this.client);
                }
                if (log.isDebugEnabled()) {
                    log.debug("STATS pollInteruppts={} pollExists={} blockLoops={} emptyQueueLoops={}", this.pollInterrupts.get(), this.pollExits.get(), this.blockLoops.get(), this.emptyQueueLoops.get());
                }
                throw throwable;
            }
            IOUtils.closeQuietly(this.client);
        }
        if (log.isDebugEnabled()) {
            log.debug("STATS pollInteruppts={} pollExists={} blockLoops={} emptyQueueLoops={}", this.pollInterrupts.get(), this.pollExits.get(), this.blockLoops.get(), this.emptyQueueLoops.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptRunnerThreadsPolling() {
        Queue<Runner> queue = this.runners;
        synchronized (queue) {
            for (Runner runner : this.runners) {
                runner.interruptPoll();
            }
        }
    }

    public void shutdownNow() {
        block9: {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                if (this.shutdownExecutor) {
                    this.scheduler.shutdown();
                    this.interruptRunnerThreadsPolling();
                    this.scheduler.shutdownNow();
                    try {
                        if (!this.scheduler.awaitTermination(30L, TimeUnit.SECONDS)) {
                            log.error("ExecutorService did not terminate");
                        }
                        break block9;
                    }
                    catch (InterruptedException ie) {
                        this.scheduler.shutdownNow();
                        Thread.currentThread().interrupt();
                    }
                    break block9;
                }
                this.interruptRunnerThreadsPolling();
            }
            finally {
                if (this.internalHttpClient) {
                    IOUtils.closeQuietly(this.client);
                }
            }
        }
    }

    @Deprecated
    public void setParser(ResponseParser responseParser) {
        this.client.setParser(responseParser);
    }

    @Deprecated
    public void setPollQueueTime(int pollQueueTime) {
        this.pollQueueTime = pollQueueTime;
        int minimalStallTime = pollQueueTime * 2;
        if (minimalStallTime > this.stallTime) {
            this.stallTime = minimalStallTime;
        }
    }

    @Deprecated
    public void setRequestWriter(RequestWriter requestWriter) {
        this.client.setRequestWriter(requestWriter);
    }

    public static class Builder
    extends SolrClientBuilder<Builder> {
        protected String baseSolrUrl;
        protected int queueSize = 10;
        protected int threadCount;
        protected int pollQueueTime = 250;
        protected ExecutorService executorService;
        protected boolean streamDeletes;

        public Builder(String baseSolrUrl) {
            this.baseSolrUrl = baseSolrUrl;
        }

        public Builder withQueueSize(int queueSize) {
            if (queueSize <= 0) {
                throw new IllegalArgumentException("queueSize must be a positive integer.");
            }
            this.queueSize = queueSize;
            return this;
        }

        public Builder withThreadCount(int threadCount) {
            if (threadCount <= 0) {
                throw new IllegalArgumentException("threadCount must be a positive integer.");
            }
            this.threadCount = threadCount;
            return this;
        }

        public Builder withPollQueueTime(int pollQueueTime) {
            this.pollQueueTime = pollQueueTime;
            return this;
        }

        public Builder withExecutorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder alwaysStreamDeletes() {
            this.streamDeletes = true;
            return this;
        }

        public Builder neverStreamDeletes() {
            this.streamDeletes = false;
            return this;
        }

        public ConcurrentUpdateSolrClient build() {
            if (this.baseSolrUrl == null) {
                throw new IllegalArgumentException("Cannot create HttpSolrClient without a valid baseSolrUrl!");
            }
            return new ConcurrentUpdateSolrClient(this);
        }

        @Override
        public Builder getThis() {
            return this;
        }
    }

    static class Update {
        UpdateRequest request;
        String collection;

        public Update(UpdateRequest request, String collection) {
            this.request = request;
            this.collection = collection;
        }

        public UpdateRequest getRequest() {
            return this.request;
        }

        public void setRequest(UpdateRequest request) {
            this.request = request;
        }

        public String getCollection() {
            return this.collection;
        }

        public void setCollection(String collection) {
            this.collection = collection;
        }
    }

    class Runner
    implements Runnable {
        volatile Thread thread = null;
        volatile boolean inPoll = false;

        Runner() {
        }

        public Thread getThread() {
            return this.thread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.thread = Thread.currentThread();
            log.debug("starting runner: {}", (Object)this);
            while (true) {
                try {
                    this.sendUpdateStream();
                    continue;
                }
                catch (Throwable e) {
                    if (e instanceof OutOfMemoryError) {
                        throw (OutOfMemoryError)e;
                    }
                    ConcurrentUpdateSolrClient.this.handleError(e);
                    continue;
                }
                finally {
                    Queue<Runner> queue = ConcurrentUpdateSolrClient.this.runners;
                    synchronized (queue) {
                        if (ConcurrentUpdateSolrClient.this.runners.size() != 1 || ConcurrentUpdateSolrClient.this.queue.isEmpty() || ExecutorUtil.isShutdown(ConcurrentUpdateSolrClient.this.scheduler)) {
                            ConcurrentUpdateSolrClient.this.runners.remove(this);
                            if (ConcurrentUpdateSolrClient.this.runners.isEmpty()) {
                                ConcurrentUpdateSolrClient.this.runners.notifyAll();
                            }
                            break;
                        }
                    }
                    continue;
                }
                break;
            }
            log.debug("finished: {}", (Object)this);
        }

        public void interruptPoll() {
            Thread lthread = this.thread;
            if (this.inPoll && lthread != null) {
                lthread.interrupt();
            }
        }

        /*
         * Exception decompiling
         */
        void sendUpdateStream() throws Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[CATCHBLOCK], 11[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

