/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.solr.client.solrj.cloud.AlreadyExistsException;
import org.apache.solr.client.solrj.cloud.BadVersionException;
import org.apache.solr.client.solrj.cloud.NotEmptyException;
import org.apache.solr.client.solrj.cloud.VersionedData;
import org.apache.solr.common.SolrCloseable;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.PerReplicaStates;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.Watcher;

public interface DistribStateManager
extends SolrCloseable {
    public boolean hasData(String var1) throws IOException, KeeperException, InterruptedException;

    public List<String> listData(String var1) throws NoSuchElementException, IOException, KeeperException, InterruptedException;

    public List<String> listData(String var1, Watcher var2) throws NoSuchElementException, IOException, KeeperException, InterruptedException;

    public VersionedData getData(String var1, Watcher var2) throws NoSuchElementException, IOException, KeeperException, InterruptedException;

    default public VersionedData getData(String path) throws NoSuchElementException, IOException, KeeperException, InterruptedException {
        return this.getData(path, null);
    }

    public Map<String, Object> getJson(String var1) throws InterruptedException, IOException, KeeperException;

    public void makePath(String var1) throws AlreadyExistsException, IOException, KeeperException, InterruptedException;

    public void makePath(String var1, byte[] var2, CreateMode var3, boolean var4) throws AlreadyExistsException, IOException, KeeperException, InterruptedException;

    public String createData(String var1, byte[] var2, CreateMode var3) throws AlreadyExistsException, IOException, KeeperException, InterruptedException;

    public void removeData(String var1, int var2) throws NoSuchElementException, IOException, NotEmptyException, KeeperException, InterruptedException, BadVersionException;

    public void setData(String var1, byte[] var2, int var3) throws BadVersionException, NoSuchElementException, IOException, KeeperException, InterruptedException;

    public List<OpResult> multi(Iterable<Op> var1) throws BadVersionException, NoSuchElementException, AlreadyExistsException, IOException, KeeperException, InterruptedException;

    default public List<String> listTree(String root) throws NoSuchElementException, IOException, KeeperException, InterruptedException {
        String node;
        ArrayDeque<Object> queue = new ArrayDeque<Object>();
        ArrayList<String> tree = new ArrayList<String>();
        if (!((String)root).startsWith("/")) {
            root = "/" + (String)root;
        }
        queue.add(root);
        tree.add((String)root);
        while ((node = (String)queue.pollFirst()) != null) {
            List<String> children = this.listData(node);
            for (String child : children) {
                String childPath = node + (node.equals("/") ? "" : "/") + child;
                queue.add(childPath);
                tree.add(childPath);
            }
        }
        return tree;
    }

    default public PerReplicaStates getReplicaStates(String path) throws KeeperException, InterruptedException {
        throw new UnsupportedOperationException("Not implemented");
    }

    default public DocCollection.PrsSupplier getPrsSupplier(String collName) {
        return new DocCollection.PrsSupplier(() -> {
            try {
                return this.getReplicaStates(DocCollection.getCollectionPath(collName));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    default public void removeRecursively(String root, boolean ignoreMissing, boolean includeRoot) throws NoSuchElementException, IOException, NotEmptyException, KeeperException, InterruptedException, BadVersionException {
        List<String> tree;
        try {
            tree = this.listTree(root);
        }
        catch (NoSuchElementException e) {
            if (ignoreMissing) {
                return;
            }
            throw e;
        }
        Collections.reverse(tree);
        for (String p : tree) {
            if (p.equals("/") || p.equals(root) && !includeRoot) continue;
            try {
                this.removeData(p, -1);
            }
            catch (NoSuchElementException e) {
                if (ignoreMissing) continue;
                throw e;
            }
        }
    }
}

