/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaBeanPropertyMapDecorator;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.LazyDynaClass;
import org.apache.commons.beanutils.MutableDynaClass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LazyDynaBean
implements DynaBean,
Serializable {
    private transient Log logger = LogFactory.getLog(LazyDynaBean.class);
    protected static final BigInteger BigInteger_ZERO = new BigInteger("0");
    protected static final BigDecimal BigDecimal_ZERO = new BigDecimal("0");
    protected static final Character Character_SPACE = new Character(' ');
    protected static final Byte Byte_ZERO = new Byte(0);
    protected static final Short Short_ZERO = new Short(0);
    protected static final Integer Integer_ZERO = new Integer(0);
    protected static final Long Long_ZERO = new Long(0L);
    protected static final Float Float_ZERO = new Float(0.0f);
    protected static final Double Double_ZERO = new Double(0.0);
    protected Map<String, Object> values = this.newMap();
    private transient Map<String, Object> mapDecorator;
    protected MutableDynaClass dynaClass;

    public LazyDynaBean() {
        this(new LazyDynaClass());
    }

    public LazyDynaBean(String name) {
        this(new LazyDynaClass(name));
    }

    public LazyDynaBean(DynaClass dynaClass) {
        this.dynaClass = dynaClass instanceof MutableDynaClass ? (MutableDynaClass)dynaClass : new LazyDynaClass(dynaClass.getName(), dynaClass.getDynaProperties());
    }

    public Map<String, Object> getMap() {
        if (this.mapDecorator == null) {
            this.mapDecorator = new DynaBeanPropertyMapDecorator(this);
        }
        return this.mapDecorator;
    }

    public int size(String name) {
        if (name == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        Object value = this.values.get(name);
        if (value == null) {
            return 0;
        }
        if (value instanceof Map) {
            return ((Map)value).size();
        }
        if (value instanceof List) {
            return ((List)value).size();
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value);
        }
        return 0;
    }

    @Override
    public boolean contains(String name, String key) {
        if (name == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        Object value = this.values.get(name);
        if (value == null) {
            return false;
        }
        if (value instanceof Map) {
            return ((Map)value).containsKey(key);
        }
        return false;
    }

    @Override
    public Object get(String name) {
        if (name == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        Object value = this.values.get(name);
        if (value != null) {
            return value;
        }
        if (!this.isDynaProperty(name)) {
            return null;
        }
        value = this.createProperty(name, this.dynaClass.getDynaProperty(name).getType());
        if (value != null) {
            this.set(name, value);
        }
        return value;
    }

    @Override
    public Object get(String name, int index) {
        if (!this.isDynaProperty(name)) {
            this.set(name, this.defaultIndexedProperty(name));
        }
        Object indexedProperty = this.get(name);
        if (!this.dynaClass.getDynaProperty(name).isIndexed()) {
            throw new IllegalArgumentException("Non-indexed property for '" + name + "[" + index + "]' " + this.dynaClass.getDynaProperty(name).getName());
        }
        if ((indexedProperty = this.growIndexedProperty(name, indexedProperty, index)).getClass().isArray()) {
            return Array.get(indexedProperty, index);
        }
        if (indexedProperty instanceof List) {
            return ((List)indexedProperty).get(index);
        }
        throw new IllegalArgumentException("Non-indexed property for '" + name + "[" + index + "]' " + indexedProperty.getClass().getName());
    }

    @Override
    public Object get(String name, String key) {
        if (!this.isDynaProperty(name)) {
            this.set(name, this.defaultMappedProperty(name));
        }
        Object mappedProperty = this.get(name);
        if (!this.dynaClass.getDynaProperty(name).isMapped()) {
            throw new IllegalArgumentException("Non-mapped property for '" + name + "(" + key + ")' " + this.dynaClass.getDynaProperty(name).getType().getName());
        }
        if (mappedProperty instanceof Map) {
            return ((Map)mappedProperty).get(key);
        }
        throw new IllegalArgumentException("Non-mapped property for '" + name + "(" + key + ")'" + mappedProperty.getClass().getName());
    }

    @Override
    public DynaClass getDynaClass() {
        return this.dynaClass;
    }

    @Override
    public void remove(String name, String key) {
        if (name == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        Object value = this.values.get(name);
        if (value == null) {
            return;
        }
        if (!(value instanceof Map)) {
            throw new IllegalArgumentException("Non-mapped property for '" + name + "(" + key + ")'" + value.getClass().getName());
        }
        ((Map)value).remove(key);
    }

    @Override
    public void set(String name, Object value) {
        if (!this.isDynaProperty(name)) {
            if (this.dynaClass.isRestricted()) {
                throw new IllegalArgumentException("Invalid property name '" + name + "' (DynaClass is restricted)");
            }
            if (value == null) {
                this.dynaClass.add(name);
            } else {
                this.dynaClass.add(name, value.getClass());
            }
        }
        DynaProperty descriptor2 = this.dynaClass.getDynaProperty(name);
        if (value == null) {
            if (descriptor2.getType().isPrimitive()) {
                throw new NullPointerException("Primitive value for '" + name + "'");
            }
        } else if (!this.isAssignable(descriptor2.getType(), value.getClass())) {
            throw new ConversionException("Cannot assign value of type '" + value.getClass().getName() + "' to property '" + name + "' of type '" + descriptor2.getType().getName() + "'");
        }
        this.values.put(name, value);
    }

    @Override
    public void set(String name, int index, Object value) {
        if (!this.isDynaProperty(name)) {
            this.set(name, this.defaultIndexedProperty(name));
        }
        Object indexedProperty = this.get(name);
        if (!this.dynaClass.getDynaProperty(name).isIndexed()) {
            throw new IllegalArgumentException("Non-indexed property for '" + name + "[" + index + "]'" + this.dynaClass.getDynaProperty(name).getType().getName());
        }
        if ((indexedProperty = this.growIndexedProperty(name, indexedProperty, index)).getClass().isArray()) {
            Array.set(indexedProperty, index, value);
        } else if (indexedProperty instanceof List) {
            List values2 = (List)indexedProperty;
            values2.set(index, value);
        } else {
            throw new IllegalArgumentException("Non-indexed property for '" + name + "[" + index + "]' " + indexedProperty.getClass().getName());
        }
    }

    @Override
    public void set(String name, String key, Object value) {
        if (!this.isDynaProperty(name)) {
            this.set(name, this.defaultMappedProperty(name));
        }
        Object mappedProperty = this.get(name);
        if (!this.dynaClass.getDynaProperty(name).isMapped()) {
            throw new IllegalArgumentException("Non-mapped property for '" + name + "(" + key + ")'" + this.dynaClass.getDynaProperty(name).getType().getName());
        }
        Map valuesMap = (Map)mappedProperty;
        valuesMap.put(key, value);
    }

    protected Object growIndexedProperty(String name, Object indexedProperty, int index) {
        int length;
        if (indexedProperty instanceof List) {
            List list = (List)indexedProperty;
            while (index >= list.size()) {
                Class<?> contentType = this.getDynaClass().getDynaProperty(name).getContentType();
                Object value = null;
                if (contentType != null) {
                    value = this.createProperty(name + "[" + list.size() + "]", contentType);
                }
                list.add(value);
            }
        }
        if (indexedProperty.getClass().isArray() && index >= (length = Array.getLength(indexedProperty))) {
            Class<?> componentType = indexedProperty.getClass().getComponentType();
            Object newArray = Array.newInstance(componentType, index + 1);
            System.arraycopy(indexedProperty, 0, newArray, 0, length);
            indexedProperty = newArray;
            this.set(name, indexedProperty);
            int newLength = Array.getLength(indexedProperty);
            for (int i = length; i < newLength; ++i) {
                Array.set(indexedProperty, i, this.createProperty(name + "[" + i + "]", componentType));
            }
        }
        return indexedProperty;
    }

    protected Object createProperty(String name, Class<?> type2) {
        if (type2 == null) {
            return null;
        }
        if (type2.isArray() || List.class.isAssignableFrom(type2)) {
            return this.createIndexedProperty(name, type2);
        }
        if (Map.class.isAssignableFrom(type2)) {
            return this.createMappedProperty(name, type2);
        }
        if (DynaBean.class.isAssignableFrom(type2)) {
            return this.createDynaBeanProperty(name, type2);
        }
        if (type2.isPrimitive()) {
            return this.createPrimitiveProperty(name, type2);
        }
        if (Number.class.isAssignableFrom(type2)) {
            return this.createNumberProperty(name, type2);
        }
        return this.createOtherProperty(name, type2);
    }

    protected Object createIndexedProperty(String name, Class<?> type2) {
        Object indexedProperty = null;
        if (type2 == null) {
            indexedProperty = this.defaultIndexedProperty(name);
        } else if (type2.isArray()) {
            indexedProperty = Array.newInstance(type2.getComponentType(), 0);
        } else if (List.class.isAssignableFrom(type2)) {
            if (type2.isInterface()) {
                indexedProperty = this.defaultIndexedProperty(name);
            } else {
                try {
                    indexedProperty = type2.newInstance();
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Error instantiating indexed property of type '" + type2.getName() + "' for '" + name + "' " + ex);
                }
            }
        } else {
            throw new IllegalArgumentException("Non-indexed property of type '" + type2.getName() + "' for '" + name + "'");
        }
        return indexedProperty;
    }

    protected Object createMappedProperty(String name, Class<?> type2) {
        Map<String, Object> mappedProperty = null;
        if (type2 == null) {
            mappedProperty = this.defaultMappedProperty(name);
        } else if (type2.isInterface()) {
            mappedProperty = this.defaultMappedProperty(name);
        } else if (Map.class.isAssignableFrom(type2)) {
            try {
                mappedProperty = type2.newInstance();
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Error instantiating mapped property of type '" + type2.getName() + "' for '" + name + "' " + ex);
            }
        } else {
            throw new IllegalArgumentException("Non-mapped property of type '" + type2.getName() + "' for '" + name + "'");
        }
        return mappedProperty;
    }

    protected Object createDynaBeanProperty(String name, Class<?> type2) {
        try {
            return type2.newInstance();
        }
        catch (Exception ex) {
            if (this.logger().isWarnEnabled()) {
                this.logger().warn("Error instantiating DynaBean property of type '" + type2.getName() + "' for '" + name + "' " + ex);
            }
            return null;
        }
    }

    protected Object createPrimitiveProperty(String name, Class<?> type2) {
        if (type2 == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (type2 == Integer.TYPE) {
            return Integer_ZERO;
        }
        if (type2 == Long.TYPE) {
            return Long_ZERO;
        }
        if (type2 == Double.TYPE) {
            return Double_ZERO;
        }
        if (type2 == Float.TYPE) {
            return Float_ZERO;
        }
        if (type2 == Byte.TYPE) {
            return Byte_ZERO;
        }
        if (type2 == Short.TYPE) {
            return Short_ZERO;
        }
        if (type2 == Character.TYPE) {
            return Character_SPACE;
        }
        return null;
    }

    protected Object createNumberProperty(String name, Class<?> type2) {
        return null;
    }

    protected Object createOtherProperty(String name, Class<?> type2) {
        if (type2 == Object.class || type2 == String.class || type2 == Boolean.class || type2 == Character.class || Date.class.isAssignableFrom(type2)) {
            return null;
        }
        try {
            return type2.newInstance();
        }
        catch (Exception ex) {
            if (this.logger().isWarnEnabled()) {
                this.logger().warn("Error instantiating property of type '" + type2.getName() + "' for '" + name + "' " + ex);
            }
            return null;
        }
    }

    protected Object defaultIndexedProperty(String name) {
        return new ArrayList();
    }

    protected Map<String, Object> defaultMappedProperty(String name) {
        return new HashMap<String, Object>();
    }

    protected boolean isDynaProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        if (this.dynaClass instanceof LazyDynaClass) {
            return ((LazyDynaClass)this.dynaClass).isDynaProperty(name);
        }
        return this.dynaClass.getDynaProperty(name) != null;
    }

    protected boolean isAssignable(Class<?> dest, Class<?> source2) {
        return dest.isAssignableFrom(source2) || dest == Boolean.TYPE && source2 == Boolean.class || dest == Byte.TYPE && source2 == Byte.class || dest == Character.TYPE && source2 == Character.class || dest == Double.TYPE && source2 == Double.class || dest == Float.TYPE && source2 == Float.class || dest == Integer.TYPE && source2 == Integer.class || dest == Long.TYPE && source2 == Long.class || dest == Short.TYPE && source2 == Short.class;
    }

    protected Map<String, Object> newMap() {
        return new HashMap<String, Object>();
    }

    private Log logger() {
        if (this.logger == null) {
            this.logger = LogFactory.getLog(LazyDynaBean.class);
        }
        return this.logger;
    }
}

