/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils.pica.reader.xml;

import de.gwdg.metadataqa.marc.utils.pica.reader.xml.PicaXmlHandler;
import de.gwdg.metadataqa.marc.utils.pica.reader.xml.PicaXmlParser;
import javax.xml.transform.sax.TransformerHandler;
import org.marc4j.MarcException;
import org.marc4j.RecordStack;
import org.xml.sax.InputSource;

public class PicaXmlParserThread
extends Thread {
    private final RecordStack queue;
    private volatile InputSource input;
    private volatile TransformerHandler th;
    private volatile String idField;
    private volatile char idCode;

    public PicaXmlParserThread(RecordStack queue) {
        this.queue = queue;
    }

    public PicaXmlParserThread(RecordStack queue, InputSource input, String idField, char idCode) {
        this.queue = queue;
        this.input = input;
        this.idField = idField;
        this.idCode = idCode;
    }

    public TransformerHandler getTransformerHandler() {
        return this.th;
    }

    public void setTransformerHandler(TransformerHandler th) {
        this.th = th;
    }

    public InputSource getInputSource() {
        return this.input;
    }

    public void setInputSource(InputSource input) {
        this.input = input;
    }

    @Override
    public void run() {
        try {
            PicaXmlHandler handler = new PicaXmlHandler(this.queue, this.idField, this.idCode);
            PicaXmlParser parser = new PicaXmlParser(handler);
            if (this.th == null) {
                parser.parse(this.input);
            } else {
                parser.parse(this.input, this.th);
            }
        }
        catch (MarcException me) {
            this.queue.passException(me);
        }
        finally {
            this.queue.end();
        }
    }
}

