/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils.pica.reader.xml;

import de.gwdg.metadataqa.marc.utils.pica.PicaDataField;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.marc4j.MarcException;
import org.marc4j.RecordStack;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Leader;
import org.marc4j.marc.MarcFactory;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.marc4j.marc.impl.ControlFieldImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class PicaXmlHandler
implements ContentHandler {
    private static final Logger logger = Logger.getLogger(PicaXmlHandler.class.getCanonicalName());
    private final String idField;
    private final char idCode;
    private Record record;
    private RecordStack queue;
    private StringBuffer sb;
    private Subfield subfield;
    private ControlField controlField;
    private PicaDataField dataField;
    private String tag;
    private String prev_tag = "n/a";
    private static final int COLLECTION_ID = 1;
    private static final int LEADER_ID = 2;
    private static final int RECORD_ID = 3;
    private static final int CONTROLFIELD_ID = 4;
    private static final int DATAFIELD_ID = 5;
    private static final int SUBFIELD_ID = 6;
    private static final String TAG_ATTR = "tag";
    private static final String CODE_ATTR = "code";
    private static final String IND_1_ATTR = "ind1";
    private static final String IND_2_ATTR = "ind2";
    private static final String TYPE_ATTR = "type";
    private static final Map<String, Integer> ELEMENTS = new HashMap<String, Integer>();
    private static final Set<String> RECORD_TYPES;
    private MarcFactory factory = null;

    public PicaXmlHandler(RecordStack queue, String idField, char idCode) {
        this.queue = queue;
        this.idField = idField;
        this.idCode = idCode;
        this.factory = MarcFactory.newInstance();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
        this.queue.end();
    }

    @Override
    public void startPrefixMapping(String s, String s1) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String s) throws SAXException {
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) throws SAXException {
        String realname = name.length() == 0 ? qName : name;
        Integer elementType = ELEMENTS.get(this.stripNsPrefix(realname));
        if (elementType == null) {
            if (this.record != null) {
                this.record.addError("n/a", "n/a", 2, "Unexpected XML element: " + realname);
                return;
            }
            throw new MarcException("Unexpected XML element: " + realname);
        }
        switch (elementType) {
            case 1: {
                break;
            }
            case 3: {
                String typeAttr = atts.getValue(TYPE_ATTR);
                this.record = this.factory.newRecord();
                if (typeAttr != null && RECORD_TYPES.contains(typeAttr)) {
                    this.record.setType(typeAttr);
                }
                this.prev_tag = "n/a";
                break;
            }
            case 2: {
                this.sb = new StringBuffer();
                break;
            }
            case 4: {
                this.tag = atts.getValue(TAG_ATTR);
                if (this.tag == null) {
                    if (this.record != null) {
                        this.record.addError("n/a", "n/a", 2, "Missing tag element in ControlField after tag: " + this.prev_tag);
                        break;
                    }
                    throw new MarcException("ControlField missing tag value, found outside a record element");
                }
                this.controlField = this.factory.newControlField(this.tag);
                this.sb = new StringBuffer();
                break;
            }
            case 5: {
                this.tag = atts.getValue(TAG_ATTR);
                if (this.tag == null) {
                    if (this.record != null) {
                        this.record.addError("n/a", "n/a", 2, "Missing tag element in datafield after tag: " + this.prev_tag);
                        break;
                    }
                    throw new MarcException("DataField missing tag value, found outside a record element");
                }
                this.dataField = new PicaDataField(this.tag);
                String occurrence = atts.getValue("occurrence");
                if (occurrence != null) {
                    this.dataField.setOccurrence(occurrence);
                }
                for (int i = 0; i < atts.getLength(); ++i) {
                    if (atts.getLocalName(i).equals(TAG_ATTR) || atts.getLocalName(i).equals("occurrence")) continue;
                    logger.warning("unhandled attr: " + atts.getLocalName(i));
                }
                break;
            }
            case 6: {
                String code = atts.getValue(CODE_ATTR);
                if (code == null) {
                    if (this.record != null) {
                        this.record.addError(this.tag, "n/a", 2, "Subfield (" + this.tag + ") missing code attribute");
                        break;
                    }
                    throw new MarcException("Subfield in DataField (" + this.tag + ") missing code attribute");
                }
                if (code.length() == 0) {
                    code = " ";
                }
                this.subfield = this.factory.newSubfield(code.charAt(0));
                this.sb = new StringBuffer();
            }
        }
        this.prev_tag = this.tag;
    }

    @Override
    public void endElement(String uri, String name, String qName) throws SAXException {
        String realname = name.length() == 0 ? qName : name;
        String element = this.stripNsPrefix(realname);
        Integer elementType = ELEMENTS.get(element);
        if (elementType == null) {
            if (this.record != null) {
                return;
            }
            throw new MarcException("Unexpected XML element: " + realname);
        }
        switch (elementType) {
            case 1: {
                break;
            }
            case 3: {
                this.setId();
                this.queue.push(this.record);
                break;
            }
            case 2: {
                Leader leader = this.factory.newLeader(this.sb.toString());
                this.record.setLeader(leader);
                break;
            }
            case 4: {
                if (this.controlField == null) break;
                this.controlField.setData(this.sb.toString());
                this.record.addVariableField(this.controlField);
                this.controlField = null;
                break;
            }
            case 5: {
                if (this.dataField == null) break;
                this.record.addVariableField(this.dataField);
                this.dataField = null;
                break;
            }
            case 6: {
                if (this.dataField == null || this.subfield == null) break;
                this.subfield.setData(this.sb.toString());
                this.dataField.addSubfield(this.subfield);
                this.subfield = null;
            }
        }
    }

    private void setId() {
        for (DataField field : this.record.getDataFields()) {
            Subfield subfield;
            if (!field.getTag().equals(this.idField) || (subfield = field.getSubfield(this.idCode)) == null) continue;
            this.record.addVariableField(new ControlFieldImpl("001", subfield.getData()));
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.sb != null) {
            this.sb.append(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] chars, int i, int i1) throws SAXException {
    }

    @Override
    public void processingInstruction(String s, String s1) throws SAXException {
    }

    @Override
    public void skippedEntity(String s) throws SAXException {
    }

    private String stripNsPrefix(String aName) {
        int index = aName.indexOf(":");
        if (index == -1 || index + 1 == aName.length()) {
            return aName;
        }
        return aName.substring(index + 1);
    }

    static {
        ELEMENTS.put("collection", 1);
        ELEMENTS.put("leader", 2);
        ELEMENTS.put("record", 3);
        ELEMENTS.put("controlfield", 4);
        ELEMENTS.put("datafield", 5);
        ELEMENTS.put("subfield", 6);
        RECORD_TYPES = new HashSet<String>();
        RECORD_TYPES.add("Bibliographic");
        RECORD_TYPES.add("Authority");
        RECORD_TYPES.add("Holdings");
        RECORD_TYPES.add("Classification");
        RECORD_TYPES.add("Community");
    }
}

