/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils.pica;

import de.gwdg.metadataqa.marc.utils.pica.PicaDataField;
import de.gwdg.metadataqa.marc.utils.pica.PicaFieldDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PicaSchemaManager {
    Map<String, PicaFieldDefinition> directory = new HashMap<String, PicaFieldDefinition>();
    Map<String, List<String>> tagIndex = new HashMap<String, List<String>>();

    public void add(PicaFieldDefinition definition) {
        String id = definition.getId();
        if (this.directory.containsKey(id)) {
            System.err.println("Tag is already defined! " + definition.getTag() + " " + this.directory.get(id));
        }
        this.directory.put(id, definition);
        if (!this.tagIndex.containsKey(definition.getTag())) {
            this.tagIndex.put(definition.getTag(), new ArrayList());
        }
        this.tagIndex.get(definition.getTag()).add(id);
    }

    public PicaFieldDefinition lookup(PicaDataField dataField) {
        String tag = dataField.getTag();
        String occurrence = dataField.getOccurrence();
        if (occurrence != null) {
            return this.getPicaFieldDefinition(tag, occurrence);
        }
        return this.lookup(tag);
    }

    public PicaFieldDefinition lookup(String searchTerm) {
        if (this.directory.containsKey(searchTerm)) {
            return this.directory.get(searchTerm);
        }
        if (searchTerm.contains("/")) {
            String[] parts = searchTerm.split("/");
            String tag = parts[0];
            String occurrence = parts[1];
            return this.getPicaFieldDefinition(tag, occurrence);
        }
        if (this.tagIndex.containsKey(searchTerm) && this.tagIndex.get(searchTerm).size() == 1) {
            String id = this.tagIndex.get(searchTerm).get(0);
            return this.directory.get(id);
        }
        return null;
    }

    private PicaFieldDefinition getPicaFieldDefinition(String tag, String occurrence) {
        if (this.tagIndex.containsKey(tag)) {
            for (String id : this.tagIndex.get(tag)) {
                PicaFieldDefinition candidate = this.directory.get(id);
                if (!candidate.inRange(occurrence)) continue;
                return candidate;
            }
        }
        return null;
    }

    public int size() {
        return this.directory.size();
    }
}

