/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils.marcspec;

import de.gwdg.metadataqa.marc.utils.marcspec.ComparisonString;
import de.gwdg.metadataqa.marc.utils.marcspec.Field;
import de.gwdg.metadataqa.marc.utils.marcspec.MARCspec;
import de.gwdg.metadataqa.marc.utils.marcspec.Position;
import de.gwdg.metadataqa.marc.utils.marcspec.Positions;
import de.gwdg.metadataqa.marc.utils.marcspec.SubSpec;
import de.gwdg.metadataqa.marc.utils.marcspec.SubTerm;
import de.gwdg.metadataqa.marc.utils.marcspec.Subfield;
import de.gwdg.metadataqa.marc.utils.marcspec.exception.InvalidMARCspecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class MARCspecParser {
    protected static final Pattern namedGroupsPattern = Pattern.compile("\\(\\?<([a-zA-Z][a-zA-Z0-9]*)>");
    protected static final Pattern FIELDTAG = Pattern.compile("^(?<tag>(?:[0-9\\.]{3}|LDR|LEADER))?");
    protected static final Pattern POSITION_OR_RANGE = Pattern.compile("(?:(?:(?:\\d+|#)\\-(?:\\d+|#))|(?:\\d+|#))");
    protected static final Pattern NAMED_POSITION_OR_RANGE = Pattern.compile("(?:(?:(?<start>\\d+|#)\\-(?<end>\\d+|#))|(?<single>\\d+|#))");
    protected static final Pattern INDEX = Pattern.compile("(?:\\[(?<index>" + POSITION_OR_RANGE.pattern() + ")\\])?");
    protected static final Pattern CHARPOS = Pattern.compile("\\/(?<charpos>" + POSITION_OR_RANGE.pattern() + ")");
    protected static final Pattern OLD_INDICATORS = Pattern.compile("_(?<indicators>(?:[_a-z0-9][_a-z0-9]{0,1}))");
    protected static final Pattern INDICATORS = Pattern.compile("\\^(?<indicators>[12])");
    protected static Pattern F_SUBSPECS;
    protected static Pattern SF_SUBSPECS;
    protected static final Pattern SUBSPECS;
    protected static final Pattern SUBFIELDS;
    protected static final Pattern FIELD;
    protected static final Pattern SUBFIELDTAGRANGE;
    protected static final Pattern NAMED_SUBFIELDTAGRANGE;
    protected static final Pattern SUBFIELDTAG;
    protected static final Pattern SUBFIELD;
    protected static final Pattern LEFTSUBTERM;
    protected static final Pattern OPERATOR;
    protected static final Pattern SUBTERMS;
    protected static final Pattern SUBSPEC;
    protected static final Pattern SUBSPEC_DELIMITER;
    protected static final Map<Pattern, List<String>> patternNames;
    protected static final List<Pattern> allPatterns;
    private Map<String, String> parsed = new HashMap<String, String>();
    private Map<String, Object> parsedFieldSpec = new HashMap<String, Object>();
    private List<Map<String, String>> parsedSubfieldSpec = new ArrayList<Map<String, String>>();

    public MARCspecParser() {
    }

    public MARCspec parse(String spec) {
        Positions positions;
        MARCspec marcSpec = new MARCspec();
        if (StringUtils.isBlank(spec)) {
            throw new InvalidMARCspecException("The string is empty", "");
        }
        Matcher matcher = FIELD.matcher(spec);
        if (!matcher.matches()) {
            throw new InvalidMARCspecException("input", spec);
        }
        Field field = null;
        Map<String, String> fieldMap = this.extractValues(matcher);
        field = new Field();
        marcSpec.setField(field);
        if (fieldMap.containsKey("tag")) {
            field.setTag(fieldMap.get("tag"));
        }
        if (fieldMap.containsKey("index") && StringUtils.isNotBlank(fieldMap.get("index")) && (positions = this.extractPositions(fieldMap.get("index"))) != null) {
            field.setIndexStartEnd(positions.getStart(), positions.getEnd());
        }
        if (fieldMap.containsKey("charpos") && StringUtils.isNotBlank(fieldMap.get("charpos"))) {
            field.setCharacterPositions(this.extractPositions(fieldMap.get("charpos")));
        }
        if (fieldMap.containsKey("indicators") && StringUtils.isNotBlank(fieldMap.get("indicators"))) {
            String ind = fieldMap.get("indicators");
            if (ind.equals("1")) {
                field.setIndicator1(ind);
            } else if (ind.equals("2")) {
                field.setIndicator2(ind);
            }
        }
        if (fieldMap.containsKey("subfields") && StringUtils.isNotBlank(fieldMap.get("subfields"))) {
            this.processSubfields(marcSpec, fieldMap.get("subfields"));
        }
        if (fieldMap.containsKey("subspecs") && StringUtils.isNotBlank(fieldMap.get("subspecs"))) {
            field.setSubSpecs(this.extractSubSpecs(marcSpec, fieldMap.get("subspecs")));
        }
        return marcSpec;
    }

    private void processSubfields(MARCspec marcSpec, String subfields) {
        Matcher matcher = SUBFIELD.matcher(subfields);
        while (matcher.find()) {
            Map<String, String> subfieldMap = this.extractValues(matcher);
            if (subfieldMap.containsKey("subfieldtagrange") && StringUtils.isNotBlank(subfieldMap.get("subfieldtagrange"))) {
                List<String> range = this.extractSubfieldRange(subfieldMap.get("subfieldtagrange"));
                for (String tag : range) {
                    marcSpec.addSubfield(new Subfield(tag));
                }
                continue;
            }
            Subfield subfield = new Subfield();
            marcSpec.addSubfield(subfield);
            if (subfieldMap.containsKey("subfieldtag") && StringUtils.isNotBlank(subfieldMap.get("subfieldtag"))) {
                subfield.setTag(subfieldMap.get("subfieldtag"));
            }
            if (subfieldMap.containsKey("index") && StringUtils.isNotBlank(subfieldMap.get("index"))) {
                subfield.setIndexPositions(this.extractPositions(subfieldMap.get("index")));
            }
            if (subfieldMap.containsKey("charpos") && StringUtils.isNotBlank(subfieldMap.get("charpos"))) {
                subfield.setCharacterPositions(this.extractPositions(subfieldMap.get("charpos")));
            }
            if (!subfieldMap.containsKey("subspecs") || !StringUtils.isNotBlank(subfieldMap.get("subspecs"))) continue;
            subfield.setSubSpecs(this.extractSubSpecs(marcSpec, subfieldMap.get("subspecs")));
        }
    }

    private List<SubSpec> extractSubSpecs(MARCspec marcSpec, String subspecsString) {
        List<List<String>> rawSubSpecsList = this.matchSubSpecs(subspecsString);
        ArrayList<SubSpec> subspecs = new ArrayList<SubSpec>();
        for (List<String> subSpecsSequence : rawSubSpecsList) {
            for (String subSpecString : subSpecsSequence) {
                Matcher subTermsMatcher = SUBTERMS.matcher(subSpecString);
                if (!subTermsMatcher.matches()) continue;
                SubSpec subSpec = new SubSpec();
                subSpec.setOperator(subTermsMatcher.group("operator"));
                SubTerm leftsubterm = new SubTerm();
                SubTerm rightsubterm = new SubTerm();
                if (StringUtils.isNotBlank(subTermsMatcher.group("leftsubterm"))) {
                    MARCspec left = this.parse(subTermsMatcher.group("leftsubterm"));
                    if (left.getField().getTag() == null) {
                        left.getField().setTag(marcSpec.getField().getTag());
                        if (left.getField().getCharacterPositions() == null && marcSpec.getField().getCharacterPositions() != null) {
                            left.getField().setCharacterPositions(marcSpec.getField().getCharacterPositions());
                        }
                        if (left.getField().getStartIndex() == null && marcSpec.getField().getStartIndex() != null) {
                            left.getField().setStartIndex(marcSpec.getField().getStartIndex());
                        }
                        if (left.getField().getEndIndex() == null && marcSpec.getField().getEndIndex() != null) {
                            left.getField().setEndIndex(marcSpec.getField().getEndIndex());
                        }
                        if (left.getSubfields().isEmpty() && !marcSpec.getSubfields().isEmpty()) {
                            left.setSubfields(marcSpec.getSubfields());
                        }
                        if (left.getField().getCharacterPositions() != null && !left.getSubfields().isEmpty()) {
                            for (Subfield subfield : left.getSubfields()) {
                                subfield.setCharacterPositions(left.getField().getCharacterPositions());
                            }
                            left.getField().setCharacterPositions(null);
                        }
                    }
                    leftsubterm.setMarcSpec(left);
                } else {
                    MARCspec copyOfThis = new MARCspec();
                    copyOfThis.setField(marcSpec.getField());
                    copyOfThis.setSubfields(marcSpec.getSubfields());
                    leftsubterm.setMarcSpec(copyOfThis);
                }
                if (StringUtils.isNotBlank(subTermsMatcher.group("rightsubterm"))) {
                    String rightsubtermString = subTermsMatcher.group("rightsubterm");
                    if (rightsubtermString.startsWith("\\")) {
                        rightsubterm.setComparisonString(new ComparisonString(rightsubtermString.substring(1)));
                    } else {
                        MARCspec right = this.parse(rightsubtermString);
                        if (StringUtils.isBlank(right.getField().getTag())) {
                            right.getField().setTag(marcSpec.getField().getTag());
                        }
                        rightsubterm.setMarcSpec(right);
                    }
                }
                subSpec.setLeftSubTerm(leftsubterm);
                subSpec.setRightSubTerm(rightsubterm);
                subspecs.add(subSpec);
            }
        }
        return subspecs;
    }

    private List<String> extractSubfieldRange(String subfieldTagRange) {
        ArrayList<String> range = null;
        Matcher rangeMatcher = NAMED_SUBFIELDTAGRANGE.matcher(subfieldTagRange);
        if (rangeMatcher.matches()) {
            String start = rangeMatcher.group("start");
            String end = rangeMatcher.group("end");
            Pattern lowerCase = Pattern.compile("[a-z]");
            Pattern upperCase = Pattern.compile("[A-Z]");
            Pattern numeric = Pattern.compile("\\d");
            if (lowerCase.matcher(start).matches() && !lowerCase.matcher(end).matches()) {
                throw new InvalidMARCspecException("Subfieldspec. Only ranges between \"a-z\", \"A-Z\" or \"0-9\" allowed.", subfieldTagRange);
            }
            if (upperCase.matcher(start).matches() && !upperCase.matcher(end).matches()) {
                throw new InvalidMARCspecException("Subfieldspec. Only ranges between \"a-z\", \"A-Z\" or \"0-9\" allowed.", subfieldTagRange);
            }
            if (numeric.matcher(start).matches() && !numeric.matcher(end).matches()) {
                throw new InvalidMARCspecException("Subfieldspec. Only ranges between \"a-z\", \"A-Z\" or \"0-9\" allowed.", subfieldTagRange);
            }
            if (start.charAt(0) > end.charAt(0)) {
                throw new InvalidMARCspecException("Subfieldspec. Only ranges between \"a-z\", \"A-Z\" or \"0-9\" allowed.", subfieldTagRange);
            }
            range = new ArrayList<String>();
            for (int i = start.charAt(0); i <= end.charAt(0); ++i) {
                range.add(Character.toString((char)i));
            }
        }
        return range;
    }

    private Positions extractPositions(String positionString) {
        Positions indexPositions = null;
        Matcher positionMatcher = NAMED_POSITION_OR_RANGE.matcher(positionString);
        if (positionMatcher.matches()) {
            indexPositions = new Positions();
            Map<String, String> indexMap = this.extractValues(positionMatcher);
            if (indexMap.containsKey("single") && StringUtils.isNotBlank(indexMap.get("single"))) {
                indexPositions.setRange(false);
                Position pos = this.createIndexPosition(indexMap.get("single"));
                indexPositions.setStart(pos);
                indexPositions.setLength(1);
            } else {
                indexPositions.setRange(true);
                indexPositions.setStart(this.createIndexPosition(indexMap.get("start")));
                indexPositions.setEnd(this.createIndexPosition(indexMap.get("end")));
                if (indexPositions.getEnd().getPositionInt() != null && indexPositions.getStart().getPositionInt() != null) {
                    indexPositions.setLength(indexPositions.getEnd().getPositionInt() + 1 - indexPositions.getStart().getPositionInt());
                }
            }
        }
        return indexPositions;
    }

    private Position createIndexPosition(String positionString) {
        Position pos = null;
        pos = positionString.equals("#") ? new Position(positionString) : new Position(Integer.parseInt(positionString));
        return pos;
    }

    public MARCspecParser(String spec) {
        if (StringUtils.isBlank(spec)) {
            return;
        }
        this.fieldToArray(spec);
        if (this.parsed.containsKey("subfields") && StringUtils.isNotBlank(this.parsed.get("subfields"))) {
            this.parsedSubfieldSpec = this.matchSubfields(this.parsed.get("subfields"));
        }
    }

    public void fieldToArray(String fieldspec) {
        List<String> _fieldGroups = Arrays.asList("field", "tag", "index", "charpos", "indicators", "subfields");
        Matcher matcher = FIELD.matcher(fieldspec);
        if (matcher.matches()) {
            this.parsed = this.extractValues(matcher);
            for (Map.Entry<String, String> entry : this.parsed.entrySet()) {
                this.parsedFieldSpec.put(entry.getKey(), entry.getValue());
            }
            if (!this.parsed.containsKey("field")) {
                throw new InvalidMARCspecException("Fieldspec. For fieldtag only \".\" and digits and lowercase alphabetic or digits and upper case alphabetics characters are allowed", fieldspec);
            }
            if (this.parsed.get("field").length() != fieldspec.length()) {
                throw new InvalidMARCspecException("Fieldspec. Detected useless data fragment.", fieldspec);
            }
            if (this.parsedFieldSpec.containsKey("charpos") && this.parsedFieldSpec.get("charpos") != null) {
                if (this.parsedFieldSpec.containsKey("indicators") && this.parsedFieldSpec.get("indicators") != null) {
                    throw new InvalidMARCspecException("Fieldspec. Either characterSpec or indicators are allowed.", fieldspec);
                }
                if (this.parsedFieldSpec.containsKey("subfields") && this.parsedFieldSpec.get("subfields") != null) {
                    throw new InvalidMARCspecException("Fieldspec. Either characterSpec for field or subfields are allowed.", fieldspec);
                }
                if (this.parsed.containsKey("subspecs") && this.parsed.get("subspecs") != null) {
                    List<List<String>> _fieldSubSpecs = this.matchSubSpecs(this.parsed.get("subspecs"));
                    this.parsedFieldSpec.put("subspecs", new ArrayList());
                    for (List<String> fieldSubSpec : _fieldSubSpecs) {
                        if (1 < fieldSubSpec.size()) {
                            ArrayList<Map<String, String>> _or = new ArrayList<Map<String, String>>();
                            for (String orSubSpec : fieldSubSpec) {
                                _or.add(this.matchSubTerms(orSubSpec));
                            }
                            ((List)this.parsedFieldSpec.get("subspecs")).addAll(_or);
                            continue;
                        }
                        ((List)this.parsedFieldSpec.get("subspecs")).add(this.matchSubTerms(fieldSubSpec.get(0)));
                    }
                }
            }
        } else {
            throw new InvalidMARCspecException("Fieldspec. Cannot detect fieldspec.", fieldspec);
        }
    }

    public List<Map<String, String>> matchSubfields(String subfieldspec) {
        List<Map<String, String>> _subfieldMatches = null;
        Matcher matcher = SUBFIELD.matcher(subfieldspec);
        if (matcher.groupCount() > 1) {
            StringBuffer test = new StringBuffer();
            ArrayList<Map<String, String>> subfields = new ArrayList<Map<String, String>>();
            while (matcher.find()) {
                Map<String, String> _subfield = this.extractValues(matcher);
                subfields.add(_subfield);
                test.append(_subfield.get("subfield"));
                if (!_subfield.containsKey("subspecs")) continue;
                ArrayList arrayList = new ArrayList();
            }
            if (!test.toString().equals(subfieldspec)) {
                throw new InvalidMARCspecException("Subfieldspec. Detected useless data fragment.", subfieldspec);
            }
        } else {
            throw new InvalidMARCspecException("Subfieldspec. For subfields only digits, lowercase alphabetic characters or one of \"!\"#$%&\"()*+,-./0-9:;<=>?[\\]^_`a-z{}~\" are allowed.", subfieldspec);
        }
        return _subfieldMatches;
    }

    public Map<String, String> subfieldToArray(String subfieldspec) {
        List<Map<String, String>> _sf = this.matchSubfields(subfieldspec);
        if (_sf == null) {
            throw new InvalidMARCspecException("Subfieldspec. Assuming invalid spec.", subfieldspec);
        }
        if (1 < _sf.size()) {
            throw new InvalidMARCspecException("Subfieldspec. Detected more than one subfieldspecs. Use method addSubfields to add more than one subfield.", subfieldspec);
        }
        if (!_sf.get(0).get("subfield").equals(subfieldspec)) {
            throw new InvalidMARCspecException("Subfieldspec. Detected useless data fragment.", subfieldspec);
        }
        return _sf.get(0);
    }

    private List<List<String>> matchSubSpecs(String subSpecsString) {
        ArrayList<List<String>> subSpecs = new ArrayList<List<String>>();
        Matcher matcher = SUBSPEC.matcher(subSpecsString);
        if (matcher.groupCount() > 0) {
            while (matcher.find()) {
                String subSpec = matcher.group(1);
                subSpecs.add(Arrays.asList(subSpec.split(SUBSPEC_DELIMITER.pattern())));
            }
        } else {
            throw new InvalidMARCspecException("Subspec. Assuming invalid spec.", subSpecsString);
        }
        return subSpecs;
    }

    private Map<String, String> matchSubTerms(String subSpec) {
        Map<String, String> terms = null;
        Pattern matchSubTermsFilterPattern = Pattern.compile("(?<![\\\\\\$])[\\{\\}]");
        if (!matchSubTermsFilterPattern.matcher(subSpec).matches()) {
            throw new InvalidMARCspecException("Subspec. Unescaped character detected", subSpec);
        }
        Matcher matcher = SUBTERMS.matcher(subSpec);
        if (matcher.groupCount() > 1) {
            while (matcher.find()) {
                terms = this.extractValues(matcher);
                if (terms.get("operator") == null) {
                    terms.put("operator", "?");
                }
                if (terms.get("rightsubterm") != null) continue;
                throw new InvalidMARCspecException("Subspec. Right hand subTerm is missing.", subSpec);
            }
        } else {
            throw new InvalidMARCspecException("Subspec. Assuming invalid spec.", subSpec);
        }
        return terms;
    }

    public static List<String> getNamedGroupCandidates(String regex) {
        ArrayList<String> namedGroups = new ArrayList<String>();
        Matcher m = namedGroupsPattern.matcher(regex);
        while (m.find()) {
            namedGroups.add(m.group(1));
        }
        return namedGroups;
    }

    public static Map<Pattern, List<String>> getPatternNames() {
        return patternNames;
    }

    public Map<String, String> extractValues(Matcher matcher) {
        TreeMap<String, String> values2 = new TreeMap<String, String>();
        for (String field : patternNames.get(matcher.pattern())) {
            values2.put(field, matcher.group(field));
        }
        return values2;
    }

    public Map<String, Object> getParsedFieldSpec() {
        return this.parsedFieldSpec;
    }

    static {
        SUBSPECS = Pattern.compile("(?<subspecs>(?:\\{.+?(?<!(?<!(\\$|\\\\))(\\$|\\\\))\\})*)");
        SUBFIELDS = Pattern.compile("(?<subfields>\\$.+)?");
        FIELD = Pattern.compile("(?<field>(?:" + FIELDTAG.pattern() + INDEX.pattern() + "(?:" + CHARPOS.pattern() + "|" + INDICATORS.pattern() + ")?" + SUBSPECS.pattern() + SUBFIELDS.pattern() + "))");
        SUBFIELDTAGRANGE = Pattern.compile("(?<subfieldtagrange>(?:[0-9a-z]\\-[0-9a-z]))");
        NAMED_SUBFIELDTAGRANGE = Pattern.compile("(?<subfieldtagrange>(?<start>[0-9a-z])\\-(?<end>[0-9a-z]))");
        SUBFIELDTAG = Pattern.compile("(?<subfieldtag>[\\!-\\?\\[-\\{\\}-~])");
        SUBFIELD = Pattern.compile("(?<subfield>\\$(?:" + SUBFIELDTAGRANGE.pattern() + "|" + SUBFIELDTAG.pattern() + ")" + INDEX.pattern() + "(?:" + CHARPOS + ")?" + SUBSPECS + ")");
        LEFTSUBTERM = Pattern.compile("^(?<leftsubterm>(?:\\\\(?:(?<=\\\\)[!=~\\?]|[^!=~\\?])+)|(?:(?<=\\$)[!=~\\?]|[^!=~\\?])+)?");
        OPERATOR = Pattern.compile("(?<operator>!=|!~|=|~|!|\\?)");
        SUBTERMS = Pattern.compile("(?:" + LEFTSUBTERM.pattern() + OPERATOR.pattern() + ")?(?<rightsubterm>.+)$");
        SUBSPEC = Pattern.compile("(?:\\{(.+?)\\})");
        SUBSPEC_DELIMITER = Pattern.compile("(?<!\\\\)\\|");
        patternNames = new HashMap<Pattern, List<String>>();
        allPatterns = Arrays.asList(FIELDTAG, POSITION_OR_RANGE, NAMED_POSITION_OR_RANGE, INDEX, CHARPOS, INDICATORS, SUBSPECS, SUBFIELDS, FIELD, SUBFIELDTAGRANGE, SUBFIELDTAG, SUBFIELD, LEFTSUBTERM, OPERATOR, SUBTERMS, SUBSPEC);
        for (Pattern pattern : allPatterns) {
            patternNames.put(pattern, MARCspecParser.getNamedGroupCandidates(pattern.pattern()));
        }
    }
}

