/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils.marcreader;

import de.gwdg.metadataqa.marc.MarcFactory;
import de.gwdg.metadataqa.marc.utils.alephseq.MarclineLine;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.marc4j.MarcReader;
import org.marc4j.marc.Record;

public class MarclineReader
implements MarcReader {
    private static final Logger logger = Logger.getLogger(MarclineReader.class.getCanonicalName());
    private BufferedReader bufferedReader = null;
    private String line = null;
    private boolean nextIsConsumed = false;
    private int lineNumber = 0;
    private int skippedRecords = 0;
    private List<MarclineLine> lines = new ArrayList<MarclineLine>();
    private String currentId = null;

    public MarclineReader(String content) {
        try {
            this.bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(content), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "MarclineReader", e);
        }
    }

    public MarclineReader(InputStream stream) {
        this.bufferedReader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
    }

    @Override
    public boolean hasNext() {
        if (this.lineNumber == 0 || this.nextIsConsumed) {
            try {
                this.line = this.bufferedReader.readLine();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "hasNext", e);
            }
            ++this.lineNumber;
            this.nextIsConsumed = false;
        }
        return this.line != null;
    }

    @Override
    public Record next() {
        Record marc4jRecord = null;
        boolean finished = false;
        while (this.line != null && !finished) {
            MarclineLine marclineLine = new MarclineLine(this.line, this.lineNumber);
            if (marclineLine.isLeader() && !this.lines.isEmpty()) {
                marc4jRecord = MarcFactory.createRecordFromMarcline(this.lines);
                if (marc4jRecord.getControlNumber() == null) {
                    this.logSkipped("does not have a control number field (001)");
                } else if (marc4jRecord.getLeader() == null) {
                    this.logSkipped("does not have a leader");
                } else {
                    finished = true;
                }
                this.lines = new ArrayList<MarclineLine>();
            }
            if (marclineLine.isValidTag()) {
                this.lines.add(marclineLine);
            }
            this.currentId = marclineLine.getRecordID();
            try {
                this.line = this.bufferedReader.readLine();
                ++this.lineNumber;
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "next", e);
            }
        }
        if (this.line == null && !this.lines.isEmpty()) {
            marc4jRecord = MarcFactory.createRecordFromMarcline(this.lines);
        }
        return marc4jRecord;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getSkippedRecords() {
        return this.skippedRecords;
    }

    private void logSkipped(String message) {
        this.logSkipped(LEVEL.SEVERE, message);
    }

    private void logSkipped(LEVEL level, String message) {
        String entry = String.format("line #%d: record %s %s. Skipped.", this.lineNumber, this.currentId, message);
        if (!level.equals((Object)LEVEL.WARN)) {
            logger.severe(entry);
        }
        ++this.skippedRecords;
    }

    private static enum LEVEL {
        WARN,
        SEVERE;

    }
}

