/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils;

import de.gwdg.metadataqa.marc.cli.parameters.CommonParameters;
import de.gwdg.metadataqa.marc.definition.MarcFormat;
import de.gwdg.metadataqa.marc.utils.marcreader.AlephseqMarcReader;
import de.gwdg.metadataqa.marc.utils.marcreader.LineSeparatedMarcReader;
import de.gwdg.metadataqa.marc.utils.marcreader.MarcMakerReader;
import de.gwdg.metadataqa.marc.utils.marcreader.MarclineReader;
import de.gwdg.metadataqa.marc.utils.pica.reader.PicaNormalizedReader;
import de.gwdg.metadataqa.marc.utils.pica.reader.PicaPlainReader;
import de.gwdg.metadataqa.marc.utils.pica.reader.PicaReader;
import de.gwdg.metadataqa.marc.utils.pica.reader.PicaXmlReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.marc4j.MarcReader;
import org.marc4j.MarcStreamReader;
import org.marc4j.MarcXmlReader;

public final class QAMarcReaderFactory {
    private CommonParameters parameters;

    private QAMarcReaderFactory(CommonParameters parameters2) {
        this.parameters = parameters2;
    }

    private MarcReader getIsoFileReader(String fileName) throws Exception {
        return this.getIsoStreamReader(new FileInputStream(fileName));
    }

    private MarcReader getIsoStreamReader(InputStream stream) {
        String encoding = this.parameters != null ? this.parameters.getDefaultEncoding() : null;
        return new MarcStreamReader(stream, encoding);
    }

    private MarcReader getXmlFileReader(String fileName) throws Exception {
        return this.getXmlStreamReader(new FileInputStream(fileName));
    }

    private MarcReader getXmlStreamReader(InputStream stream) {
        return new MarcXmlReader(stream);
    }

    private MarcReader getLineSeparatedFileReader(String fileName) {
        return new LineSeparatedMarcReader(fileName);
    }

    private MarcReader getLineSeparatedStreamReader(InputStream stream) {
        return new LineSeparatedMarcReader(stream);
    }

    private MarcReader getAlephseqFileReader(String fileName) {
        AlephseqMarcReader reader = new AlephseqMarcReader(fileName);
        this.confiigureAlephseqMarcReader(reader);
        return reader;
    }

    private MarcReader getAlephseqStreamReader(InputStream stream) {
        AlephseqMarcReader reader = new AlephseqMarcReader(stream);
        this.confiigureAlephseqMarcReader(reader);
        return reader;
    }

    private void confiigureAlephseqMarcReader(AlephseqMarcReader reader) {
        if (this.parameters != null && this.parameters.getAlephseqLineType() != null) {
            reader.setLineType(this.parameters.getAlephseqLineType());
        }
    }

    private MarcReader getPicaPlainFileReader(String fileName, CommonParameters parameters2) {
        PicaPlainReader reader = new PicaPlainReader(fileName);
        this.configurePicaReader(reader, parameters2);
        return reader;
    }

    private MarcReader getPicaPlainStreamReader(InputStream stream, CommonParameters parameters2) {
        String encoding = parameters2 != null && StringUtils.isNotBlank(parameters2.getDefaultEncoding()) ? parameters2.getDefaultEncoding() : "UTF-8";
        PicaPlainReader reader = new PicaPlainReader(stream, encoding);
        this.configurePicaReader(reader, parameters2);
        return reader;
    }

    private MarcReader getPicaNormalizedFileReader(String fileName, CommonParameters parameters2) {
        PicaNormalizedReader reader = new PicaNormalizedReader(fileName);
        this.configurePicaReader(reader, parameters2);
        return reader;
    }

    private MarcReader getPicaNormalizedStreamReader(InputStream stream, CommonParameters parameters2) {
        String encoding = parameters2 != null && StringUtils.isNotBlank(parameters2.getDefaultEncoding()) ? parameters2.getDefaultEncoding() : "UTF-8";
        PicaNormalizedReader reader = new PicaNormalizedReader(stream, encoding);
        this.configurePicaReader(reader, parameters2);
        reader.parseIdField();
        return reader;
    }

    private MarcReader getPicaXmlFileReader(String fileName, CommonParameters parameters2) throws Exception {
        return this.getPicaXmlStreamReader(new FileInputStream(fileName), parameters2);
    }

    private MarcReader getPicaXmlStreamReader(InputStream stream, CommonParameters parameters2) {
        PicaXmlReader reader = new PicaXmlReader(stream);
        this.configurePicaReader(reader, parameters2);
        return reader;
    }

    private void configurePicaReader(PicaReader reader, CommonParameters parameters2) {
        if (parameters2 != null) {
            if (StringUtils.isNotEmpty(parameters2.getPicaIdField())) {
                reader.setIdField(parameters2.getPicaIdField());
            }
            if (StringUtils.isNotEmpty(parameters2.getPicaSubfieldSeparator())) {
                reader.setSubfieldSeparator(parameters2.getPicaSubfieldSeparator());
            }
        }
    }

    private MarcReader getMarclineFileReader(String fileName) {
        return new MarclineReader(fileName);
    }

    private MarcReader getMarclineStreamReader(InputStream stream) {
        return new MarclineReader(stream);
    }

    private MarcReader getMarcMakerFileReader(String fileName) {
        return new MarcMakerReader(fileName);
    }

    private MarcReader getMarcMakerStreamReader(InputStream stream) {
        return new MarcMakerReader(stream);
    }

    public static MarcReader getFileReader(MarcFormat marcFormat, String fileName) throws Exception {
        return QAMarcReaderFactory.getFileReader(marcFormat, fileName, null);
    }

    public static MarcReader getFileReader(MarcFormat marcFormat, String fileName, CommonParameters parameters2) throws Exception {
        QAMarcReaderFactory factory = new QAMarcReaderFactory(parameters2);
        MarcReader reader = null;
        switch (marcFormat) {
            case ALEPHSEQ: {
                reader = factory.getAlephseqFileReader(fileName);
                break;
            }
            case LINE_SEPARATED: {
                reader = factory.getLineSeparatedFileReader(fileName);
                break;
            }
            case XML: {
                reader = factory.getXmlFileReader(fileName);
                break;
            }
            case MARC_LINE: {
                reader = factory.getMarclineFileReader(fileName);
                break;
            }
            case MARC_MAKER: {
                reader = factory.getMarcMakerFileReader(fileName);
                break;
            }
            case PICA_PLAIN: {
                reader = factory.getPicaPlainFileReader(fileName, parameters2);
                break;
            }
            case PICA_NORMALIZED: {
                reader = factory.getPicaNormalizedFileReader(fileName, parameters2);
                break;
            }
            case PICA_XML: {
                reader = factory.getPicaXmlFileReader(fileName, parameters2);
                break;
            }
            default: {
                reader = factory.getIsoFileReader(fileName);
            }
        }
        return reader;
    }

    public static MarcReader getStreamReader(MarcFormat marcFormat, InputStream stream) {
        return QAMarcReaderFactory.getStreamReader(marcFormat, stream, null);
    }

    public static MarcReader getStreamReader(MarcFormat marcFormat, InputStream stream, CommonParameters parameters2) {
        QAMarcReaderFactory factory = new QAMarcReaderFactory(parameters2);
        MarcReader reader = null;
        switch (marcFormat) {
            case ALEPHSEQ: {
                reader = factory.getAlephseqStreamReader(stream);
                break;
            }
            case LINE_SEPARATED: {
                reader = factory.getLineSeparatedStreamReader(stream);
                break;
            }
            case XML: {
                reader = factory.getXmlStreamReader(stream);
                break;
            }
            case MARC_LINE: {
                reader = factory.getMarclineStreamReader(stream);
                break;
            }
            case MARC_MAKER: {
                reader = factory.getMarcMakerStreamReader(stream);
                break;
            }
            case PICA_PLAIN: {
                reader = factory.getPicaPlainStreamReader(stream, parameters2);
                break;
            }
            case PICA_NORMALIZED: {
                reader = factory.getPicaNormalizedStreamReader(stream, parameters2);
                break;
            }
            case PICA_XML: {
                reader = factory.getPicaXmlStreamReader(stream, parameters2);
                break;
            }
            default: {
                reader = factory.getIsoStreamReader(stream);
            }
        }
        return reader;
    }

    public static MarcReader getStringReader(MarcFormat marcFormat, String content) {
        return QAMarcReaderFactory.getStringReader(marcFormat, content, null);
    }

    public static MarcReader getStringReader(MarcFormat marcFormat, String content, CommonParameters parameters2) {
        ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes());
        return QAMarcReaderFactory.getStreamReader(marcFormat, stream, parameters2);
    }
}

