/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.model.validation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.gwdg.metadataqa.marc.CsvUtils;
import de.gwdg.metadataqa.marc.Utils;
import de.gwdg.metadataqa.marc.model.validation.ValidationError;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ValidationErrorFormatter {
    public static String format(List<ValidationError> errors, ValidationErrorFormat format) {
        return ValidationErrorFormatter.format(errors, format, false);
    }

    public static String format(List<ValidationError> errors, ValidationErrorFormat format, boolean trimId) {
        StringBuffer message = new StringBuffer();
        switch (format) {
            case TAB_SEPARATED: 
            case COMMA_SEPARATED: {
                for (ValidationError error : errors) {
                    error.setTrimId(trimId);
                    message.append(ValidationErrorFormatter.format(error, format) + "\n");
                }
                break;
            }
            case TEXT: {
                String id = errors.get(0).getRecordId();
                if (trimId) {
                    id = id.trim();
                }
                message.append(String.format("%s in '%s':%n", errors.size() == 1 ? "Error" : "Errors", id));
                for (ValidationError error : errors) {
                    message.append(String.format("\t%s%n", ValidationErrorFormatter.formatTextWithoutId(error)));
                }
                break;
            }
        }
        return message.toString();
    }

    public static String formatSimple(String recordId, ValidationErrorFormat format, Map<Integer, Integer> errorIdCounter) {
        char separator = format.equals((Object)ValidationErrorFormat.TAB_SEPARATED) ? (char)'\t' : ',';
        return Utils.createRow(Character.valueOf(separator), recordId, StringUtils.join(Utils.counterToList(errorIdCounter), ';'));
    }

    public static String formatHeader(ValidationErrorFormat format) {
        StringBuffer message = new StringBuffer();
        if (format.equals((Object)ValidationErrorFormat.TAB_SEPARATED)) {
            message.append(ValidationErrorFormatter.createCvsRow(ValidationErrorFormatter.headerArray(), '\t'));
        } else if (format.equals((Object)ValidationErrorFormat.COMMA_SEPARATED)) {
            message.append(ValidationErrorFormatter.createCvsRow(ValidationErrorFormatter.headerArray(), ','));
        }
        return message.toString();
    }

    public static String format(ValidationError error, ValidationErrorFormat format) {
        StringBuffer message = new StringBuffer();
        if (format.equals((Object)ValidationErrorFormat.TAB_SEPARATED)) {
            message.append(ValidationErrorFormatter.createCvsRow(ValidationErrorFormatter.asArray(error), '\t'));
        } else if (format.equals((Object)ValidationErrorFormat.COMMA_SEPARATED)) {
            message.append(ValidationErrorFormatter.createCvsRow(ValidationErrorFormatter.asArray(error), ','));
        } else if (format.equals((Object)ValidationErrorFormat.JSON)) {
            ObjectMapper mapper = new ObjectMapper();
            String json = null;
            try {
                json = mapper.writeValueAsString(error);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            message.append(json);
        }
        return message.toString();
    }

    public static List<String> formatForSummary(List<ValidationError> validationErrors, ValidationErrorFormat format) {
        ArrayList<String> messages = new ArrayList<String>();
        for (ValidationError error : validationErrors) {
            messages.add(ValidationErrorFormatter.formatForSummary(error, format));
        }
        return messages;
    }

    public static String formatHeaderForSummary(ValidationErrorFormat format, boolean withGoupId) {
        String message = "";
        switch (format) {
            case TAB_SEPARATED: {
                message = ValidationErrorFormatter.createCvsRow(ValidationErrorFormatter.headerForSummary(withGoupId), '\t');
                break;
            }
            case COMMA_SEPARATED: 
            case TEXT: {
                message = CsvUtils.createCsv(ValidationErrorFormatter.headerForSummary(withGoupId));
                break;
            }
        }
        return message;
    }

    public static String formatHeaderForDetails(ValidationErrorFormat format) {
        String message = "";
        switch (format) {
            case TAB_SEPARATED: {
                message = ValidationErrorFormatter.createCvsRow(ValidationErrorFormatter.headerForDetails(), '\t');
                break;
            }
            case COMMA_SEPARATED: 
            case TEXT: {
                message = ValidationErrorFormatter.createCvsRow(ValidationErrorFormatter.headerForDetails(), ',');
                break;
            }
        }
        return message;
    }

    public static String formatHeaderForCollector(ValidationErrorFormat format) {
        String message = "";
        switch (format) {
            case TAB_SEPARATED: {
                message = ValidationErrorFormatter.createCvsRow(ValidationErrorFormatter.headerForCollector(), '\t');
                break;
            }
            case COMMA_SEPARATED: 
            case TEXT: {
                message = ValidationErrorFormatter.createCvsRow(ValidationErrorFormatter.headerForCollector(), ',');
                break;
            }
        }
        return message;
    }

    public static String formatForSummary(ValidationError error, ValidationErrorFormat format) {
        String message = "";
        switch (format) {
            case TAB_SEPARATED: {
                message = ValidationErrorFormatter.createCvsRow(ValidationErrorFormatter.asArrayWithoutId(error), '\t');
                break;
            }
            case COMMA_SEPARATED: {
                message = ValidationErrorFormatter.createCvsRow(ValidationErrorFormatter.asArrayWithoutId(error), ',');
                break;
            }
            case TEXT: {
                message = ValidationErrorFormatter.formatTextWithoutId(error);
                break;
            }
        }
        return message;
    }

    private static String createCvsRow(String[] strings, char separator) {
        return CsvUtils.createCsv(strings);
    }

    private static String formatTextWithoutId(ValidationError error) {
        return String.format("%s: %d - %s '%s' (%s)", error.getMarcPath(), error.getType().getId(), error.getType().getMessage(), error.getMessage(), error.getUrl());
    }

    private static String[] headerForSummary(boolean withGoupId) {
        if (withGoupId) {
            return new String[]{"groupId", "id", "MarcPath", "categoryId", "typeId", "type", "message", "url", "instances", "records"};
        }
        return new String[]{"id", "MarcPath", "categoryId", "typeId", "type", "message", "url", "instances", "records"};
    }

    private static String[] headerForDetails() {
        return new String[]{"recordId", "errors"};
    }

    private static String[] headerForCollector() {
        return new String[]{"errorId", "recordIds"};
    }

    public static String[] asArrayWithoutId(ValidationError error) {
        return new String[]{error.getMarcPath(), String.valueOf(error.getType().getCategory().getId()), String.valueOf(error.getType().getId()), error.getType().getMessage(), error.getMessage(), error.getUrl()};
    }

    private static List<String> asListWithoutId(ValidationError error) {
        return Arrays.asList(error.getMarcPath(), String.valueOf(error.getType().getCategory().getId()), String.valueOf(error.getType().getId()), error.getType().getMessage(), error.getMessage(), error.getUrl());
    }

    private static List<String> asList(ValidationError error) {
        return Arrays.asList(error.getRecordId(), error.getMarcPath(), String.valueOf(error.getType().getCategory().getId()), String.valueOf(error.getType().getId()), error.getType().getMessage(), error.getMessage(), error.getUrl());
    }

    private static String[] asArray(ValidationError error) {
        return new String[]{error.getRecordId(), error.getMarcPath(), String.valueOf(error.getType().getCategory().getId()), String.valueOf(error.getType().getId()), error.getType().getMessage(), error.getMessage(), error.getUrl()};
    }

    private static String[] headerArray() {
        return new String[]{"recordId", "MarcPath", "categoryId", "typeId", "type", "message", "url"};
    }
}

