/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags84x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.codelist.OrganizationCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.RecordControlNumberParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag883
extends DataFieldDefinition {
    private static Tag883 uniqueInstance;

    private Tag883() {
        this.initialize();
        this.postCreation();
    }

    public static Tag883 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag883();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "883";
        this.label = "Metadata Provenance";
        this.mqTag = "MetadataProvenance";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd883.html";
        this.ind1 = new Indicator("Method of assignment").setCodes(" ", "No information provided/not applicable", "0", "Fully machine-generated", "1", "Partially machine-generated", "2", "Not machine-generated").setMqTag("methodOfAssignment");
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Creation process", "NR", "c", "Confidence value", "NR", "d", "Creation date", "NR", "q", "Assigning or generation agency", "NR", "x", "Validity end date", "NR", "u", "Uniform Resource Identifier", "NR", "w", "Bibliographic record control number", "R", "0", "Authority record control number or standard number", "R", "1", "Real World Object URI", "R", "8", "Field link and sequence number", "R");
        this.getSubfield("a").setMqTag("creationProcess");
        this.getSubfield("c").setMqTag("confidence");
        this.getSubfield("d").setMqTag("date");
        this.getSubfield("q").setMqTag("agency").setCodeList(OrganizationCodes.getInstance());
        this.getSubfield("x").setMqTag("validityEndDate");
        this.getSubfield("u").setMqTag("uri");
        this.getSubfield("w").setMqTag("bibliographicRecordControlNumber");
        this.getSubfield("0").setMqTag("authorityRecordControlNumber").setContentParser(RecordControlNumberParser.getInstance());
        this.getSubfield("1").setMqTag("uri");
        this.getSubfield("8").setMqTag("fieldLink");
        this.putVersionSpecificSubfields(MarcVersion.NKCR, Arrays.asList(new SubfieldDefinition("7", "NKCR Authority ID", "NR")));
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
    }
}

