/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags84x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag881
extends DataFieldDefinition {
    private static Tag881 uniqueInstance;

    private Tag881() {
        this.initialize();
        this.postCreation();
    }

    public static Tag881 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag881();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "881";
        this.label = "Manifestation Statements";
        this.mqTag = "ManifestationStatements";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd881.html";
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Manifestation statement, high-level/general", "R", "b", "Manifestation identifier statement", "R", "c", "Manifestation title and responsibility statement", "R", "d", "Manifestation edition statement", "R", "e", "Manifestation production statement", "R", "f", "Manifestation publication statement", "R", "g", "Manifestation distribution statement", "R", "h", "Manifestation manufacture statement", "R", "i", "Manifestation copyright statement", "R", "j", "Manifestation frequency statement", "R", "k", "Manifestation designation of sequence statement", "R", "l", "Manifestation series statement", "R", "m", "Manifestation dissertation statement", "R", "n", "Manifestation regional encoding statement", "R", "3", "Materials specified", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("a").setMqTag("statement");
        this.getSubfield("b").setMqTag("identifier");
        this.getSubfield("c").setMqTag("titleAndResponsibility");
        this.getSubfield("d").setMqTag("edition");
        this.getSubfield("e").setMqTag("production");
        this.getSubfield("f").setMqTag("publication");
        this.getSubfield("g").setMqTag("distribution");
        this.getSubfield("h").setMqTag("manufacture");
        this.getSubfield("i").setMqTag("copyright");
        this.getSubfield("j").setMqTag("frequency");
        this.getSubfield("k").setMqTag("designation");
        this.getSubfield("l").setMqTag("series");
        this.getSubfield("m").setMqTag("dissertation");
        this.getSubfield("n").setMqTag("regionalEncoding");
        this.getSubfield("3").setMqTag("materialsSpecified");
        this.getSubfield("6").setBibframeTag("linkage").setContentParser(LinkageParser.getInstance());
        this.getSubfield("8").setMqTag("fieldLink");
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
    }
}

