/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags70x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.SourceSpecificationType;
import de.gwdg.metadataqa.marc.definition.general.codelist.NameAndTitleAuthoritySourceCodes;
import de.gwdg.metadataqa.marc.definition.general.codelist.RelatorCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.general.parser.RecordControlNumberParser;
import de.gwdg.metadataqa.marc.definition.general.validator.ISSNValidator;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag730
extends DataFieldDefinition {
    private static Tag730 uniqueInstance;

    private Tag730() {
        this.initialize();
        this.postCreation();
    }

    public static Tag730 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag730();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "730";
        this.label = "Added Entry - Uniform Title";
        this.mqTag = "AddedUniformTitle";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd730.html";
        this.setCompilanceLevels("A");
        this.ind1 = new Indicator("Nonfiling characters").setCodes("0-9", "Number of nonfiling characters").setMqTag("nonfilingCharacters").setFrbrFunctions(FRBRFunction.ManagementProcess, FRBRFunction.ManagementSort);
        this.ind1.getCode("0-9").setRange(true);
        this.ind2 = new Indicator("Type of added entry").setCodes(" ", "No information provided", "2", "Analytical entry").setMqTag("type").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess);
        this.setSubfieldsWithCardinality("a", "Uniform title", "NR", "d", "Date of treaty signing", "R", "f", "Date of a work", "NR", "g", "Miscellaneous information", "R", "h", "Medium", "NR", "i", "Relationship information", "R", "k", "Form subheading", "R", "l", "Language of a work", "NR", "m", "Medium of performance for music", "R", "n", "Number of part/section of a work", "R", "o", "Arranged statement for music", "NR", "p", "Name of part/section of a work", "R", "r", "Key for music", "NR", "s", "Version", "R", "t", "Title of a work", "NR", "x", "International Standard Serial Number", "NR", "0", "Authority record control number or standard number", "R", "1", "Real World Object URI", "R", "2", "Source of heading or term", "NR", "3", "Materials specified", "NR", "4", "Relationship", "R", "5", "Institution to which field applies", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("x").setValidator(ISSNValidator.getInstance());
        this.getSubfield("a").setMqTag("rdf:value").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("M");
        this.getSubfield("d").setMqTag("dateOfTreaty").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("f").setMqTag("dateOfAWork").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("g").setMqTag("miscellaneous").setCompilanceLevels("A");
        this.getSubfield("h").setMqTag("medium").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("i").setMqTag("relationship").setCompilanceLevels("O");
        this.getSubfield("k").setMqTag("formSubheading").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("l").setMqTag("languageOfAWork").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("m").setMqTag("mediumOfPerformance").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("n").setMqTag("numberOfPart").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("o").setMqTag("arrangedStatement").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("p").setMqTag("nameOfPart").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("r").setMqTag("keyForMusic").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("s").setMqTag("version").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("t").setMqTag("titleOfAWork").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("x").setMqTag("issn").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("0").setMqTag("authorityRecordControlNumber").setContentParser(RecordControlNumberParser.getInstance()).setCompilanceLevels("O");
        this.getSubfield("1").setMqTag("uri");
        this.getSubfield("2").setMqTag("source").setCodeList(NameAndTitleAuthoritySourceCodes.getInstance());
        this.getSubfield("3").setMqTag("materialsSpecified").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("4").setMqTag("relationship").setCodeList(RelatorCodes.getInstance());
        this.getSubfield("5").setMqTag("institutionToWhichFieldApplies").setFrbrFunctions(FRBRFunction.ManagementProcess, FRBRFunction.ManagementDisplay).setCompilanceLevels("A");
        this.getSubfield("6").setMqTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.putVersionSpecificSubfields(MarcVersion.NKCR, Arrays.asList(new SubfieldDefinition("7", "NKCR Authority ID", "NR"), new SubfieldDefinition("9", "NKCR Authority field - tracing form", "NR")));
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
        this.sourceSpecificationType = SourceSpecificationType.Subfield2;
    }
}

