/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags6xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.SourceSpecificationType;
import de.gwdg.metadataqa.marc.definition.general.codelist.RelatorCodes;
import de.gwdg.metadataqa.marc.definition.general.codelist.SubjectHeadingAndTermSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.general.parser.RecordControlNumberParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag662
extends DataFieldDefinition {
    private static Tag662 uniqueInstance;

    private Tag662() {
        this.initialize();
        this.postCreation();
    }

    public static Tag662 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag662();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "662";
        this.label = "Subject Added Entry - Hierarchical Place Name";
        this.bibframeTag = "HierarchicalGeographic";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd662.html";
        this.setCompilanceLevels("A");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Country or larger entity", "R", "b", "First-order political jurisdiction", "NR", "c", "Intermediate political jurisdiction", "R", "d", "City", "NR", "e", "Relator term", "R", "f", "City subsection", "R", "g", "Other nonjurisdictional geographic region and feature", "R", "h", "Extraterrestrial area", "R", "0", "Authority record control number or standard number", "R", "1", "Real World Object URI", "R", "2", "Source of heading or term", "NR", "4", "Relationship", "R", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("2").setCodeList(SubjectHeadingAndTermSourceCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("country").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("M");
        this.getSubfield("b").setBibframeTag("state").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("c").setBibframeTag("county").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("d").setBibframeTag("city").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("e").setBibframeTag("relator").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("f").setBibframeTag("citySection").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("g").setBibframeTag("region").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("h").setBibframeTag("extraterrestrialArea").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("0").setMqTag("authorityRecordControlNumber").setContentParser(RecordControlNumberParser.getInstance()).setCompilanceLevels("O");
        this.getSubfield("1").setMqTag("uri");
        this.getSubfield("2").setMqTag("source").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("4").setMqTag("relationship").setCodeList(RelatorCodes.getInstance()).setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.putVersionSpecificSubfields(MarcVersion.NKCR, Arrays.asList(new SubfieldDefinition("7", "NKCR Authority ID", "NR")));
        this.putVersionSpecificSubfields(MarcVersion.MARC21NO, Arrays.asList(new SubfieldDefinition("9", "Language code", "NR")));
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
        this.sourceSpecificationType = SourceSpecificationType.Subfield2;
    }
}

