/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags6xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.SourceSpecificationType;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag653
extends DataFieldDefinition {
    private static Tag653 uniqueInstance;

    private Tag653() {
        this.initialize();
        this.postCreation();
    }

    public static Tag653 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag653();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "653";
        this.label = "Index Term - Uncontrolled";
        this.bibframeTag = "Subject";
        this.mqTag = "UncontrolledIndexTerm";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd653.html";
        this.setCompilanceLevels("A");
        this.ind1 = new Indicator("Level of index term").setCodes(" ", "No information provided", "0", "No level specified", "1", "Primary", "2", "Secondary").setMqTag("level");
        this.ind2 = new Indicator("Type of term or name").setCodes(" ", "No information provided", "0", "Topical term", "1", "Personal name", "2", "Corporate name", "3", "Meeting name", "4", "Chronological term", "5", "Geographic name", "6", "Genre/form term").setMqTag("type");
        this.setSubfieldsWithCardinality("a", "Uncontrolled term", "R", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("rdf:value").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("M");
        this.getSubfield("6").setMqTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.putVersionSpecificSubfields(MarcVersion.FENNICA, Arrays.asList(new SubfieldDefinition("9", "Sanastokoodi", "NR")));
        this.putVersionSpecificSubfields(MarcVersion.MARC21NO, Arrays.asList(new SubfieldDefinition("9", "Language code", "NR")));
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
        this.sourceSpecificationType = SourceSpecificationType.Indicator2;
    }
}

