/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags5xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag555
extends DataFieldDefinition {
    private static Tag555 uniqueInstance;

    private Tag555() {
        this.initialize();
        this.postCreation();
    }

    public static Tag555 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag555();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "555";
        this.label = "Cumulative Index/Finding Aids Note";
        this.mqTag = "CumulativeIndexOrFindingAids";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd555.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator("Display constant controller").setCodes(" ", "Indexes", "0", "Finding aids", "8", "No display constant generated").setMqTag("displayConstant").setFrbrFunctions(FRBRFunction.ManagementDisplay);
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Cumulative index/finding aids note", "NR", "b", "Availability source", "R", "c", "Degree of control", "NR", "d", "Bibliographic reference", "NR", "u", "Uniform Resource Identifier", "R", "3", "Materials specified", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("rdfs:label").setMqTag("rdf:value").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("b").setMqTag("availabilitySource").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("c").setMqTag("degreeOfControl").setCompilanceLevels("A");
        this.getSubfield("d").setMqTag("bibliographicReference").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("u").setMqTag("uri").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("3").setMqTag("materialsSpecified").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
    }
}

