/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags5xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.codelist.AccessRestrictionTermSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag540
extends DataFieldDefinition {
    private static Tag540 uniqueInstance;

    private Tag540() {
        this.initialize();
        this.postCreation();
    }

    public static Tag540 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag540();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "540";
        this.label = "Terms Governing Use and Reproduction Note";
        this.bibframeTag = "UsePolicy";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd540.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Terms governing use and reproduction", "NR", "b", "Jurisdiction", "NR", "c", "Authorization", "NR", "d", "Authorized users", "NR", "f", "Use and reproduction rights", "R", "g", "Availability date", "R", "q", "Supplying agency", "NR", "u", "Uniform Resource Identifier", "R", "2", "Source of term", "NR", "3", "Materials specified", "NR", "5", "Institution to which field applies", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("2").setCodeList(AccessRestrictionTermSourceCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("rdfs:label").setMqTag("rdf:value").setFrbrFunctions(FRBRFunction.UseRestrict).setCompilanceLevels("M");
        this.getSubfield("b").setMqTag("jurisdiction").setFrbrFunctions(FRBRFunction.UseRestrict).setCompilanceLevels("A");
        this.getSubfield("c").setBibframeTag("source").setFrbrFunctions(FRBRFunction.UseRestrict).setCompilanceLevels("A");
        this.getSubfield("d").setMqTag("authorizedUsers").setFrbrFunctions(FRBRFunction.UseRestrict).setCompilanceLevels("A");
        this.getSubfield("f").setMqTag("rights");
        this.getSubfield("g").setMqTag("availabilityDate");
        this.getSubfield("q").setMqTag("supplyingAgency");
        this.getSubfield("u").setBibframeTag("rdfs:label").setMqTag("uri").setFrbrFunctions(FRBRFunction.DiscoverySelect).setCompilanceLevels("O");
        this.getSubfield("2").setMqTag("source");
        this.getSubfield("3").setMqTag("materialsSpecified").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("5").setMqTag("institutionToWhichFieldApplies").setFrbrFunctions(FRBRFunction.ManagementProcess, FRBRFunction.ManagementDisplay).setCompilanceLevels("A");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
    }
}

