/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags5xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.codelist.SubjectHeadingAndTermSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.general.parser.RecordControlNumberParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag518
extends DataFieldDefinition {
    private static Tag518 uniqueInstance;

    private Tag518() {
        this.initialize();
        this.postCreation();
    }

    public static Tag518 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag518();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "518";
        this.label = "Date/Time and Place of an Event Note";
        this.bibframeTag = "Capture";
        this.mqTag = "DateTimeAndPlaceOfAnEventNote";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd518.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Date/time and place of an event note", "NR", "d", "Date of event", "R", "o", "Other event information", "R", "p", "Place of event", "R", "0", "Record control number", "R", "1", "Real World Object URI", "R", "2", "Source of term", "R", "3", "Materials specified", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("2").setCodeList(SubjectHeadingAndTermSourceCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("rdfs:label").setMqTag("rdf:value").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect).setCompilanceLevels("M");
        this.getSubfield("d").setBibframeTag("rdfs:label").setMqTag("date").setCompilanceLevels("A");
        this.getSubfield("o").setBibframeTag("rdfs:label").setMqTag("otherInformation").setCompilanceLevels("O");
        this.getSubfield("p").setBibframeTag("rdfs:label").setMqTag("place").setCompilanceLevels("A");
        this.getSubfield("0").setMqTag("authorityRecordControlNumber").setContentParser(RecordControlNumberParser.getInstance()).setCompilanceLevels("O");
        this.getSubfield("1").setMqTag("uri");
        this.getSubfield("2").setMqTag("source").setCompilanceLevels("A");
        this.getSubfield("3").setMqTag("materialsSpecified").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
    }
}

