/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags3xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag352
extends DataFieldDefinition {
    private static Tag352 uniqueInstance;

    private Tag352() {
        this.initialize();
        this.postCreation();
    }

    public static Tag352 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag352();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "352";
        this.label = "Digital Graphic Representation";
        this.mqTag = "DigitalGraphicRepresentation";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd352.html";
        this.setCompilanceLevels("A");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Direct reference method", "NR", "b", "Object type", "R", "c", "Object count", "R", "d", "Row count", "NR", "e", "Column count", "NR", "f", "Vertical count", "NR", "g", "VPF topology level", "NR", "i", "Indirect reference description", "NR", "q", "Format of the digital image", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("cartographicDataType").setFrbrFunctions(FRBRFunction.UseOperate, FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("b").setBibframeTag("cartographicObjectType").setFrbrFunctions(FRBRFunction.UseOperate, FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("c").setBibframeTag("count").setMqTag("objectCount").setFrbrFunctions(FRBRFunction.UseOperate, FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("d").setMqTag("rowCount").setFrbrFunctions(FRBRFunction.UseOperate, FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("e").setMqTag("columnCount").setFrbrFunctions(FRBRFunction.UseOperate, FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("f").setMqTag("verticalCount").setFrbrFunctions(FRBRFunction.UseOperate, FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("g").setMqTag("topologyLevel").setFrbrFunctions(FRBRFunction.UseOperate, FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("i").setMqTag("indirectReference").setFrbrFunctions(FRBRFunction.UseOperate, FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("q").setBibframeTag("encodingFormat").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.UseOperate, FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
    }
}

