/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags3xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag341
extends DataFieldDefinition {
    private static Tag341 uniqueInstance;

    private Tag341() {
        this.initialize();
        this.postCreation();
    }

    public static Tag341 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag341();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "341";
        this.label = "Accessibility Content";
        this.mqTag = "AccessibilityContent";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd341.html";
        this.ind1 = new Indicator("Application").setCodes(" ", "No information provided", "0", "Adaptive features to access primary content", "1", "Adaptive features to access secondary content").setMqTag("application");
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Content access mode", "NR", "b", "Textual assistive features", "R", "c", "Visual assistive features", "R", "d", "Auditory assistive features", "R", "e", "Tactile assistive features", "R", "2", "Source", "NR", "3", "Materials specified", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("a").setBibframeTag("accessMode");
        this.getSubfield("b").setBibframeTag("textualAssistiveFeatures");
        this.getSubfield("c").setBibframeTag("visualAssistiveFeatures");
        this.getSubfield("d").setMqTag("auditoryAssistiveFeatures");
        this.getSubfield("e").setMqTag("tactileAssistiveFeatures");
        this.getSubfield("2").setBibframeTag("source");
        this.getSubfield("3").setMqTag("materialsSpecified");
        this.getSubfield("6").setBibframeTag("linkage").setContentParser(LinkageParser.getInstance());
        this.getSubfield("8").setMqTag("fieldLink");
        this.putVersionSpecificSubfields(MarcVersion.NKCR, Arrays.asList(new SubfieldDefinition("7", "NKCR Authority ID", "NR")));
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
    }
}

