/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags3xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.codelist.GenreFormCodeAndTermSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.general.parser.RecordControlNumberParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag338
extends DataFieldDefinition {
    private static Tag338 uniqueInstance;

    private Tag338() {
        this.initialize();
        this.postCreation();
    }

    public static Tag338 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag338();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "338";
        this.label = "Carrier Type";
        this.bibframeTag = "Carrier";
        this.mqTag = "CarrierType";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd338.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Carrier type term", "R", "b", "Carrier type code", "R", "0", "Authority record control number or standard number", "R", "1", "Real World Object URI", "R", "2", "Source", "NR", "3", "Materials specified", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("2").setCodeList(GenreFormCodeAndTermSourceCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("rdfs:label").setMqTag("rdf:value").setCompilanceLevels("M");
        this.getSubfield("b").setMqTag("carrierTypeCode").setCompilanceLevels("M");
        this.getSubfield("0").setMqTag("authorityRecordControlNumber").setContentParser(RecordControlNumberParser.getInstance());
        this.getSubfield("1").setMqTag("uri");
        this.getSubfield("2").setBibframeTag("source").setCompilanceLevels("M");
        this.getSubfield("3").setMqTag("materialsSpecified").setCompilanceLevels("O");
        this.getSubfield("6").setBibframeTag("linkage").setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setCompilanceLevels("O");
        this.putVersionSpecificSubfields(MarcVersion.NKCR, Arrays.asList(new SubfieldDefinition("7", "NKCR Authority ID", "NR")));
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
    }
}

