/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags3xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.codelist.GenreFormCodeAndTermSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.general.parser.RecordControlNumberParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag335
extends DataFieldDefinition {
    private static Tag335 uniqueInstance;

    private Tag335() {
        this.initialize();
        this.postCreation();
    }

    public static Tag335 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag335();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "335";
        this.label = "Extension Plan";
        this.mqTag = "ExtensionPlan";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd335.html";
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Extension plan term", "NR", "b", "Extension plan code", "NR", "0", "Authority record control number or standard number", "R", "1", "Real World Object URI", "R", "2", "Source", "NR", "3", "Materials specified", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("a").setMqTag("extensionPlanTerm");
        this.getSubfield("b").setMqTag("extensionPlanCode");
        this.getSubfield("0").setMqTag("authorityRecordControlNumber").setContentParser(RecordControlNumberParser.getInstance());
        this.getSubfield("1").setMqTag("uri");
        this.getSubfield("2").setBibframeTag("source").setCodeList(GenreFormCodeAndTermSourceCodes.getInstance());
        this.getSubfield("3").setMqTag("materialsSpecified");
        this.getSubfield("6").setBibframeTag("linkage").setContentParser(LinkageParser.getInstance());
        this.getSubfield("8").setMqTag("fieldLink");
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
    }
}

