/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags01x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.codelist.DateSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag046
extends DataFieldDefinition {
    private static Tag046 uniqueInstance;

    private Tag046() {
        this.initialize();
        this.postCreation();
    }

    public static Tag046 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag046();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "046";
        this.label = "Special Coded Dates";
        this.mqTag = "SpecialCodedDates";
        this.cardinality = Cardinality.Nonrepeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd046.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Type of date code", "NR", "b", "Date 1, B.C.E. date", "NR", "c", "Date 1, C.E. date", "NR", "d", "Date 2, B.C.E. date", "NR", "e", "Date 2, C.E. date", "NR", "j", "Date resource modified", "NR", "k", "Beginning or single date created", "NR", "l", "Ending date created", "NR", "m", "Beginning of date valid", "NR", "n", "End of date valid", "NR", "o", "Single or starting date for aggregated content", "NR", "p", "Ending date for aggregated content", "NR", "2", "Source of date", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("a").setCodes("r", "Reissue and original date", "s", "Single date", "p", "Distribution and production dates", "t", "Publication and copyright dates", "x", "Incorrect dates", "q", "Questionable date", "n", "Unknown date", "i", "Inclusive dates", "k", "Bulk dates", "r", "Reissue and original dates", "m", "Multiple dates", "t", "Publication and copyright dates", "x", "Incorrect dates", "n", "Unknown date");
        this.getSubfield("2").setCodeList(DateSourceCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("type").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("b").setMqTag("bceDate1").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("c").setMqTag("bcDate1").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("d").setMqTag("bceDate2").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("e").setMqTag("ceDate2").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("j").setMqTag("modified").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("k").setMqTag("beginningCreated").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("l").setMqTag("endingCreated").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("m").setMqTag("beginningOfDateValid").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain, FRBRFunction.UseRestrict).setCompilanceLevels("A");
        this.getSubfield("n").setMqTag("endOfDateValid").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain, FRBRFunction.UseRestrict).setCompilanceLevels("A");
        this.getSubfield("o").setMqTag("startingDateForAggregated");
        this.getSubfield("p").setMqTag("endingDateForAggregated");
        this.getSubfield("2").setMqTag("source").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
    }
}

