/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags01x;

import de.gwdg.metadataqa.marc.EncodedValue;
import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.codelist.StandardIdentifierSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag024
extends DataFieldDefinition {
    private static Tag024 uniqueInstance;

    private Tag024() {
        this.initialize();
        this.postCreation();
    }

    public static Tag024 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag024();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "024";
        this.label = "Other Standard Identifier";
        this.bibframeTag = "IdentifiedBy";
        this.mqTag = "OtherStandardIdentifier";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd024.html";
        this.setCompilanceLevels("A", "A");
        this.ind1 = new Indicator("Type of standard number or code").setCodes("0", "International Standard Recording Code", "1", "Universal Product Code", "2", "International Standard Music Number", "3", "International Article Number", "4", "Serial Item and Contribution Identifier", "7", "Source specified in subfield $2", "8", "Unspecified type of standard number or code").putVersionSpecificCodes(MarcVersion.SZTE, Arrays.asList(new EncodedValue(" ", "Not specified"))).setMqTag("type").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess, FRBRFunction.ManagementDisplay);
        this.ind2 = new Indicator("Difference indicator").setCodes(" ", "No information provided", "0", "No difference", "1", "Difference").setMqTag("differenceIndicator").setFrbrFunctions(FRBRFunction.ManagementProcess, FRBRFunction.ManagementDisplay);
        this.setSubfieldsWithCardinality("a", "Standard number or code", "NR", "c", "Terms of availability", "NR", "d", "Additional codes following the standard number or code", "NR", "q", "Qualifying information", "R", "z", "Canceled/invalid standard number or code", "R", "2", "Source of number or code", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("2").setCodeList(StandardIdentifierSourceCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("rdf:value").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("M", "M");
        this.getSubfield("c").setBibframeTag("acquisitionTerms").setFrbrFunctions(FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A", "A");
        this.getSubfield("d").setBibframeTag("note").setCompilanceLevels("A", "A");
        this.getSubfield("q").setBibframeTag("qualifier");
        this.getSubfield("z").setMqTag("canceledNumber").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A", "A");
        this.getSubfield("2").setMqTag("source").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A", "A");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A", "A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.setHistoricalSubfields("b", "Additional codes following the standard number [OBSOLETE]");
        this.putVersionSpecificSubfields(MarcVersion.DNB, Arrays.asList(new SubfieldDefinition("9", "Standardnummer (mit Bindestrichen)", "NR")));
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
    }
}

