/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags01x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.codelist.OrganizationCodes;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag016
extends DataFieldDefinition {
    private static Tag016 uniqueInstance;

    private Tag016() {
        this.initialize();
        this.postCreation();
    }

    public static Tag016 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag016();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "016";
        this.label = "National Bibliographic Agency Control Number";
        this.bibframeTag = "IdIntifiedBy/Local";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd016.html";
        this.setCompilanceLevels("A", "A");
        this.ind1 = new Indicator("National bibliographic agency").setCodes(" ", "Library and Archives Canada", "7", "Source specified in subfield $2").setMqTag("agency").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess);
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Record control number", "NR", "z", "Canceled/invalid control number", "R", "2", "Source", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("2").setCodeList(OrganizationCodes.getInstance());
        this.getSubfield("a").setBibframeTag("rdf:value").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A", "A");
        this.getSubfield("z").setMqTag("canceledOrInvalidControlNumber").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A", "A");
        this.getSubfield("2").setBibframeTag("source").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A", "A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
    }
}

