/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.structure;

import de.gwdg.metadataqa.marc.EncodedValue;
import de.gwdg.metadataqa.marc.Utils;
import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.CompilanceLevel;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.bibliographic.BibliographicFieldDefinition;
import de.gwdg.metadataqa.marc.definition.general.codelist.CodeList;
import de.gwdg.metadataqa.marc.definition.general.parser.SubfieldContentParser;
import de.gwdg.metadataqa.marc.definition.general.validator.SubfieldValidator;
import de.gwdg.metadataqa.marc.definition.structure.ControlfieldPositionDefinition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class SubfieldDefinition
implements Serializable {
    private static final Logger logger = Logger.getLogger(SubfieldDefinition.class.getCanonicalName());
    private String code;
    private String bibframeTag;
    private String mqTag;
    private String cardinalityCode;
    private String label;
    private BibliographicFieldDefinition parent;
    private SubfieldValidator validator;
    private SubfieldContentParser contentParser;
    protected CodeList codeList;
    private List<EncodedValue> codes;
    private Map<MarcVersion, List<EncodedValue>> localCodes;
    private List<String> allowedCodes;
    private String codeForIndex = null;
    private List<ControlfieldPositionDefinition> positions;
    private List<FRBRFunction> functions;
    private CompilanceLevel nationalCompilanceLevel;
    private CompilanceLevel minimalCompilanceLevel;
    private List<MarcVersion> disallowedIn;
    private MarcVersion marcVersion = null;

    public String getCodeForIndex() {
        if (this.codeForIndex == null) {
            if (this.mqTag != null) {
                this.codeForIndex = this.mqTag.equals("rdf:value") ? "" : "_" + this.mqTag;
            } else if (this.bibframeTag != null) {
                switch (this.bibframeTag) {
                    case "rdf:value": {
                        this.codeForIndex = "";
                        break;
                    }
                    case "rdfs:label": {
                        this.codeForIndex = "label";
                        break;
                    }
                    default: {
                        this.codeForIndex = "_" + this.bibframeTag;
                        break;
                    }
                }
            } else {
                this.codeForIndex = this.code.equals("#") ? "_hash" : (this.code.equals("*") ? "_star" : (this.code.equals("@") ? "_at" : "_" + this.code));
            }
        }
        return this.codeForIndex;
    }

    public SubfieldDefinition(String code, String label) {
        this.code = code;
        this.label = label;
    }

    public SubfieldDefinition(String code, String label, String cardinalityCode) {
        this.code = code;
        this.label = label;
        this.cardinalityCode = cardinalityCode;
        if (code.startsWith("ind")) {
            this.processIndicatorType(cardinalityCode);
        }
    }

    public String getCode() {
        return this.code;
    }

    public String getPath() {
        return String.format("%s$%s", this.getParent().getExtendedTag(), this.getCode());
    }

    public SubfieldDefinition setCodes(List<EncodedValue> codes) {
        this.codes = codes;
        return this;
    }

    public SubfieldDefinition setCodes(String ... input) {
        this.codes = new ArrayList<EncodedValue>();
        for (int i = 0; i < input.length; i += 2) {
            this.codes.add(new EncodedValue(input[i], input[i + 1]));
        }
        return this;
    }

    public SubfieldDefinition setLocalCodes(MarcVersion version, String ... input) {
        if (this.localCodes == null) {
            this.localCodes = new EnumMap<MarcVersion, List<EncodedValue>>(MarcVersion.class);
        }
        this.localCodes.put(version, new ArrayList());
        for (int i = 0; i < input.length; i += 2) {
            this.localCodes.get((Object)version).add(new EncodedValue(input[i], input[i + 1]));
        }
        return this;
    }

    public EncodedValue getCode(String code) {
        return this.getCode(this.codes, code);
    }

    public EncodedValue getCode(List<EncodedValue> codes, String otherCode) {
        for (EncodedValue code : codes) {
            if (code.getCode().equals(otherCode)) {
                return code;
            }
            if (!code.isRange() || !code.getRange().isValid(otherCode)) continue;
            return code;
        }
        return null;
    }

    public List<EncodedValue> getCodes() {
        return this.codes;
    }

    public Map<MarcVersion, List<EncodedValue>> getLocalCodes() {
        return this.localCodes;
    }

    public List<EncodedValue> getLocalCodes(MarcVersion version) {
        return this.localCodes.getOrDefault((Object)version, null);
    }

    public EncodedValue getLocalCode(MarcVersion version, String code) {
        List<EncodedValue> codes = this.getLocalCodes(version);
        if (codes == null) {
            return null;
        }
        return this.getCode(codes, code);
    }

    public String getCardinalityCode() {
        return this.cardinalityCode;
    }

    public Cardinality getCardinality() {
        return Cardinality.byCode(this.cardinalityCode);
    }

    public String getLabel() {
        return this.label;
    }

    public List<String> getAllowedCodes() {
        return this.allowedCodes;
    }

    public SubfieldContentParser getContentParser() {
        return this.contentParser;
    }

    public boolean hasContentParser() {
        return this.contentParser != null;
    }

    public SubfieldDefinition setContentParser(SubfieldContentParser contentParser) {
        this.contentParser = contentParser;
        return this;
    }

    private void processIndicatorType(String types) {
        this.allowedCodes = new ArrayList<String>();
        if (types.equals("blank")) {
            this.allowedCodes.add(" ");
        } else {
            int len = types.length();
            for (int i = 0; i < len; ++i) {
                String type2 = String.valueOf(types.charAt(i));
                if (type2.equals("b")) {
                    type2 = " ";
                }
                this.allowedCodes.add(type2);
            }
        }
    }

    public SubfieldDefinition setValidator(SubfieldValidator validator) {
        this.validator = validator;
        return this;
    }

    public boolean hasValidator() {
        return this.validator != null;
    }

    public SubfieldValidator getValidator() {
        return this.validator;
    }

    public SubfieldDefinition setCodeList(CodeList codeList) {
        this.codeList = codeList;
        return this;
    }

    public CodeList getCodeList() {
        return this.codeList;
    }

    public String resolve(String value) {
        EncodedValue code;
        if (this.codeList != null && this.codeList.isValid(value)) {
            return this.codeList.getCode(value).getLabel();
        }
        if (this.codes != null && (code = this.getCode(value)) != null) {
            return code.getLabel();
        }
        return value;
    }

    public Map<String, String> resolvePositional(String value) {
        LinkedHashMap<String, String> pairs = new LinkedHashMap<String, String>();
        int i = 0;
        for (ControlfieldPositionDefinition def : this.getPositions()) {
            try {
                String part = Utils.substring(value, def.getPositionStart(), def.getPositionEnd());
                String resolved = def.resolve(part);
                String suffix = StringUtils.isNotBlank(def.getMqTag()) ? def.getMqTag() : String.valueOf(i);
                pairs.put(suffix, resolved);
            }
            catch (StringIndexOutOfBoundsException e) {
                logger.warning(this.getPath() + ": " + e.getLocalizedMessage());
            }
            ++i;
        }
        return pairs;
    }

    public String getBibframeTag() {
        return this.bibframeTag;
    }

    public SubfieldDefinition setBibframeTag(String bibframeTag) {
        this.bibframeTag = bibframeTag;
        return this;
    }

    public String getMqTag() {
        return this.mqTag;
    }

    public BibliographicFieldDefinition getParent() {
        return this.parent;
    }

    public List<FRBRFunction> getFrbrFunctions() {
        return this.functions;
    }

    public SubfieldDefinition setParent(BibliographicFieldDefinition parent) {
        this.parent = parent;
        return this;
    }

    public SubfieldDefinition setMqTag(String mqTag) {
        this.mqTag = mqTag;
        return this;
    }

    public void setPositions(List<ControlfieldPositionDefinition> positions) {
        this.positions = positions;
    }

    public List<ControlfieldPositionDefinition> getPositions() {
        return this.positions;
    }

    public boolean hasPositions() {
        return this.positions != null;
    }

    public SubfieldDefinition setCompilanceLevels(String national) {
        this.setNationalCompilanceLevel(national);
        return this;
    }

    public SubfieldDefinition setCompilanceLevels(String national, String minimal) {
        this.setNationalCompilanceLevel(national);
        this.setMinimalCompilanceLevel(minimal);
        return this;
    }

    public CompilanceLevel getNationalCompilanceLevel() {
        return this.nationalCompilanceLevel;
    }

    public SubfieldDefinition setNationalCompilanceLevel(CompilanceLevel nationalLevel) {
        this.nationalCompilanceLevel = nationalLevel;
        return this;
    }

    public SubfieldDefinition setNationalCompilanceLevel(String level) {
        if (StringUtils.isNotBlank(level)) {
            this.nationalCompilanceLevel = CompilanceLevel.byAbbreviation(level);
        }
        return this;
    }

    public CompilanceLevel getMinimalCompilanceLevel() {
        return this.minimalCompilanceLevel;
    }

    public SubfieldDefinition setMinimalCompilanceLevel(String level) {
        if (StringUtils.isNotBlank(level)) {
            this.minimalCompilanceLevel = CompilanceLevel.byAbbreviation(level);
        }
        return this;
    }

    public SubfieldDefinition setMinimalCompilanceLevel(CompilanceLevel minimalLevel) {
        this.minimalCompilanceLevel = minimalLevel;
        return this;
    }

    public SubfieldDefinition setFrbrFunctions(FRBRFunction ... functions2) {
        this.functions = Arrays.asList(functions2);
        return this;
    }

    public SubfieldDefinition disallowIn(MarcVersion ... versions) {
        this.disallowedIn = Arrays.asList(versions);
        return this;
    }

    public List<MarcVersion> getDisallowedIn() {
        return this.disallowedIn;
    }

    public boolean isDisallowedIn(MarcVersion marcVersion) {
        return this.disallowedIn != null && this.disallowedIn.contains((Object)marcVersion);
    }

    public MarcVersion getMarcVersion() {
        return this.marcVersion;
    }

    public void setMarcVersion(MarcVersion marcVersion) {
        this.marcVersion = marcVersion;
    }

    public String toString() {
        return "SubfieldDefinition{code='" + this.code + "', cardinality='" + this.cardinalityCode + "', label='" + this.label + "'}";
    }
}

