/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.structure;

import de.gwdg.metadataqa.marc.EncodedValue;
import de.gwdg.metadataqa.marc.Utils;
import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.CompilanceLevel;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.SourceSpecificationType;
import de.gwdg.metadataqa.marc.definition.bibliographic.BibliographicFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class DataFieldDefinition
implements BibliographicFieldDefinition,
Serializable {
    protected String tag;
    protected String bibframeTag;
    protected String mqTag;
    protected String label;
    protected Cardinality cardinality = Cardinality.Nonrepeatable;
    protected Indicator ind1;
    protected Indicator ind2;
    protected String descriptionUrl;
    protected List<SubfieldDefinition> subfields;
    protected Map<String, SubfieldDefinition> subfieldIndex = new LinkedHashMap<String, SubfieldDefinition>();
    protected List<EncodedValue> historicalSubfields;
    protected Map<String, EncodedValue> historicalSubfieldsIndex;
    protected String indexTag = null;
    protected Map<MarcVersion, List<SubfieldDefinition>> versionSpecificSubfields;
    protected List<FRBRFunction> functions;
    protected SourceSpecificationType sourceSpecificationType = null;
    protected boolean obsolete = false;
    private CompilanceLevel nationalCompilanceLevel;
    private CompilanceLevel minimalCompilanceLevel;
    private MarcVersion marcVersion;

    @Override
    public String getTag() {
        return this.tag;
    }

    public String getIndexTag() {
        if (this.indexTag == null) {
            this.indexTag = this.mqTag != null ? this.mqTag : (this.bibframeTag != null ? this.bibframeTag.replace("/", "") : this.tag);
        }
        return this.indexTag;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Cardinality getCardinality() {
        return this.cardinality;
    }

    public Indicator getInd1() {
        return this.ind1;
    }

    public Indicator getInd2() {
        return this.ind2;
    }

    public List<Indicator> getIndicators() {
        return Arrays.asList(this.ind1, this.ind2);
    }

    protected void postCreation() {
        this.setIndicatorFlags();
    }

    protected void setIndicatorFlags() {
        if (this.ind1 != null) {
            this.ind1.setParent(this);
            this.ind1.setIndicatorFlag("ind1");
        }
        if (this.ind2 != null) {
            this.ind2.setParent(this);
            this.ind2.setIndicatorFlag("ind2");
        }
    }

    public List<SubfieldDefinition> getSubfields() {
        return this.subfields;
    }

    protected void setSubfields(String ... input) {
        this.subfields = new LinkedList<SubfieldDefinition>();
        for (int i = 0; i < input.length; i += 2) {
            this.subfields.add(new SubfieldDefinition(input[i], input[i + 1]));
        }
        this.indexSubfields();
    }

    protected void setSubfieldsWithCardinality(String ... input) {
        this.subfields = new LinkedList<SubfieldDefinition>();
        for (int i = 0; i < input.length; i += 3) {
            String code = input[i];
            String label = input[i + 1];
            String cardinality = input[i + 2];
            SubfieldDefinition definition = new SubfieldDefinition(code, label, cardinality);
            definition.setParent(this);
            this.subfields.add(definition);
        }
        this.indexSubfields();
    }

    protected void indexSubfields() {
        for (SubfieldDefinition subfield : this.subfields) {
            this.subfieldIndex.put(subfield.getCode(), subfield);
        }
    }

    protected DataFieldDefinition setHistoricalSubfields(String ... input) {
        this.historicalSubfields = new LinkedList<EncodedValue>();
        for (int i = 0; i < input.length; i += 2) {
            this.historicalSubfields.add(new EncodedValue(input[i], input[i + 1]));
        }
        this.indexHistoricalSubfields();
        return this;
    }

    private void indexHistoricalSubfields() {
        this.historicalSubfieldsIndex = new LinkedHashMap<String, EncodedValue>();
        for (EncodedValue code : this.historicalSubfields) {
            this.historicalSubfieldsIndex.put(code.getCode(), code);
        }
    }

    public boolean isHistoricalSubfield(String code) {
        return this.historicalSubfields != null && !this.historicalSubfields.isEmpty() && this.historicalSubfieldsIndex.containsKey(code);
    }

    @Override
    public String getDescriptionUrl() {
        return this.descriptionUrl;
    }

    public SubfieldDefinition getSubfield(String code) {
        return this.subfieldIndex.getOrDefault(code, null);
    }

    public void putVersionSpecificSubfields(MarcVersion marcVersion, List<SubfieldDefinition> subfieldDefinitions) {
        if (this.versionSpecificSubfields == null) {
            this.versionSpecificSubfields = new EnumMap<MarcVersion, List<SubfieldDefinition>>(MarcVersion.class);
        }
        for (SubfieldDefinition subfieldDefinition : subfieldDefinitions) {
            subfieldDefinition.setParent(this);
            subfieldDefinition.setMarcVersion(marcVersion);
        }
        this.versionSpecificSubfields.put(marcVersion, subfieldDefinitions);
    }

    public Map<MarcVersion, List<SubfieldDefinition>> getVersionSpecificSubfields() {
        return this.versionSpecificSubfields;
    }

    public boolean hasVersionSpecificSubfields(MarcVersion marcVersion) {
        return this.versionSpecificSubfields.containsKey((Object)marcVersion);
    }

    public boolean isVersionSpecificSubfields(MarcVersion marcVersion, String code) {
        if (this.versionSpecificSubfields != null && !this.versionSpecificSubfields.isEmpty() && this.versionSpecificSubfields.containsKey((Object)marcVersion) && !this.versionSpecificSubfields.get((Object)marcVersion).isEmpty()) {
            for (SubfieldDefinition subfieldDefinition : this.versionSpecificSubfields.get((Object)marcVersion)) {
                if (!subfieldDefinition.getCode().equals(code)) continue;
                return true;
            }
        }
        return false;
    }

    public SubfieldDefinition getVersionSpecificSubfield(MarcVersion marcVersion, String code) {
        if (this.isVersionSpecificSubfields(marcVersion, code)) {
            for (SubfieldDefinition subfieldDefinition : this.versionSpecificSubfields.get((Object)marcVersion)) {
                if (!subfieldDefinition.getCode().equals(code)) continue;
                return subfieldDefinition;
            }
        }
        return null;
    }

    public List<EncodedValue> getHistoricalSubfields() {
        return this.historicalSubfields;
    }

    public String getMqTag() {
        return this.mqTag;
    }

    public List<FRBRFunction> getFrbrFunctions() {
        return this.functions;
    }

    public SourceSpecificationType getSourceSpecificationType() {
        return this.sourceSpecificationType;
    }

    public void setCompilanceLevels(String national) {
        this.setNationalCompilanceLevel(national);
    }

    public void setCompilanceLevels(String national, String minimal) {
        this.setNationalCompilanceLevel(national);
        this.setMinimalCompilanceLevel(minimal);
    }

    public CompilanceLevel getNationalCompilanceLevel() {
        return this.nationalCompilanceLevel;
    }

    public void setNationalCompilanceLevel(CompilanceLevel nationalLevel) {
        this.nationalCompilanceLevel = nationalLevel;
    }

    public void setNationalCompilanceLevel(String level) {
        if (StringUtils.isNotBlank(level)) {
            this.nationalCompilanceLevel = CompilanceLevel.byAbbreviation(level);
        }
    }

    public CompilanceLevel getMinimalCompilanceLevel() {
        return this.minimalCompilanceLevel;
    }

    public void setMinimalCompilanceLevel(String level) {
        if (StringUtils.isNotBlank(level)) {
            this.minimalCompilanceLevel = CompilanceLevel.byAbbreviation(level);
        }
    }

    public void setMinimalCompilanceLevel(CompilanceLevel minimalLevel) {
        this.minimalCompilanceLevel = minimalLevel;
    }

    public MarcVersion getMarcVersion() {
        if (this.marcVersion == null) {
            this.marcVersion = Utils.getVersion(this);
        }
        return this.marcVersion;
    }

    public boolean isObsolete() {
        return this.obsolete;
    }

    public String toString() {
        return "DataFieldDefinition{tag='" + this.tag + "', label='" + this.label + "', cardinality=" + this.cardinality + ", descriptionUrl='" + this.descriptionUrl + "'}";
    }
}

