/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.structure;

import de.gwdg.metadataqa.marc.EncodedValue;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.general.codelist.CodeList;
import de.gwdg.metadataqa.marc.definition.general.parser.SubfieldContentParser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ControlfieldPositionDefinition
implements Serializable {
    protected static final Pattern TRIMMABLE = Pattern.compile("^[^ ]+ +$");
    protected String id;
    protected String label;
    protected String bibframeTag;
    protected String mqTag;
    protected int positionStart;
    protected int positionEnd;
    protected List<EncodedValue> codes;
    protected List<EncodedValue> historicalCodes;
    protected CodeList codeList;
    protected List<String> validCodes = new ArrayList<String>();
    protected int unitLength = -1;
    protected boolean repeatableContent = false;
    protected String defaultCode;
    protected String descriptionUrl;
    protected SubfieldContentParser parser;
    protected List<FRBRFunction> functions;

    public ControlfieldPositionDefinition() {
    }

    public ControlfieldPositionDefinition(String label, int positionStart, int positionEnd) {
        this.label = label;
        this.positionStart = positionStart;
        this.positionEnd = positionEnd;
        this.validCodes = new ArrayList<String>();
    }

    public ControlfieldPositionDefinition(String label, int positionStart, int positionEnd, List<EncodedValue> codes) {
        this(label, positionStart, positionEnd);
        this.codes = codes;
        this.extractValidCodes();
    }

    public ControlfieldPositionDefinition setCodes(List<EncodedValue> codes) {
        this.codes = codes;
        this.extractValidCodes();
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public String getBibframeTag() {
        return this.bibframeTag;
    }

    public ControlfieldPositionDefinition setBibframeTag(String bibframeTag) {
        this.bibframeTag = bibframeTag;
        return this;
    }

    public String getMqTag() {
        return this.mqTag;
    }

    public ControlfieldPositionDefinition setMqTag(String mqTag) {
        this.mqTag = mqTag;
        return this;
    }

    public int getPositionStart() {
        return this.positionStart;
    }

    public int getPositionEnd() {
        return this.positionEnd;
    }

    public List<EncodedValue> getCodes() {
        return this.codes;
    }

    public int getUnitLength() {
        return this.unitLength;
    }

    public String getId() {
        return this.id;
    }

    public ControlfieldPositionDefinition setId(String id) {
        this.id = id;
        return this;
    }

    public ControlfieldPositionDefinition setUnitLength(int unitLength) {
        this.unitLength = unitLength;
        return this;
    }

    public boolean isRepeatableContent() {
        return this.repeatableContent;
    }

    public ControlfieldPositionDefinition setRepeatableContent(boolean repeatableContent) {
        this.repeatableContent = repeatableContent;
        return this;
    }

    public String getDefaultCode() {
        return this.defaultCode;
    }

    public ControlfieldPositionDefinition setCodeList(CodeList codeList) {
        this.codeList = codeList;
        return this;
    }

    public CodeList getCodeList() {
        return this.codeList;
    }

    public ControlfieldPositionDefinition setDefaultCode(String defaultCode) {
        this.defaultCode = defaultCode;
        return this;
    }

    public String getDescriptionUrl() {
        return this.descriptionUrl;
    }

    public boolean validate(String code) {
        if (this.isRepeatableContent()) {
            return this.validateRepeatable(code);
        }
        return this.validCodes.contains(code);
    }

    private boolean validateRepeatable(String code) {
        for (int i = 0; i < code.length(); i += this.unitLength) {
            String unit = code.substring(i, i + this.unitLength);
            if (this.validCodes.contains(unit)) continue;
            return false;
        }
        return true;
    }

    public String resolve(String inputCode) {
        if (this.codes != null || this.codeList != null) {
            inputCode = this.repeatableContent ? this.resolveRepeatable(inputCode) : this.resolveSingleCode(inputCode);
        }
        return inputCode;
    }

    private String resolveRepeatable(String inputCode) {
        ArrayList<String> units = new ArrayList<String>();
        for (int i = 0; i < inputCode.length(); i += this.unitLength) {
            String unit = inputCode.substring(i, i + this.unitLength);
            if (units.contains(unit)) continue;
            units.add(unit);
        }
        ArrayList<String> resolved = new ArrayList<String>();
        for (String unit : units) {
            resolved.add(this.resolveSingleCode(unit));
        }
        inputCode = StringUtils.join(resolved, ", ");
        return inputCode;
    }

    private String resolveSingleCode(String inputCode) {
        if (this.codeList != null) {
            String trimmed;
            if (inputCode.length() > 1 && TRIMMABLE.matcher(inputCode).matches() && this.codeList.isValid(trimmed = inputCode.trim())) {
                return this.codeList.getCode(trimmed).getLabel();
            }
            if (this.codeList.isValid(inputCode.trim())) {
                return this.codeList.getCode(inputCode.trim()).getLabel();
            }
        }
        if (this.codes != null) {
            for (EncodedValue code : this.codes) {
                if (!code.getCode().equals(inputCode)) continue;
                return code.getLabel();
            }
        }
        return inputCode;
    }

    protected void extractValidCodes() {
        if (this.codes == null) {
            return;
        }
        for (EncodedValue code : this.codes) {
            this.validCodes.add(code.getCode());
        }
    }

    public List<String> getValidCodes() {
        return this.validCodes;
    }

    public String formatPositon() {
        return this.positionStart == this.positionEnd - 1 ? String.format("%02d", this.positionStart) : String.format("%02d-%02d", this.positionStart, this.positionEnd - 1);
    }

    public String getControlField() {
        String className = this.getClass().getSimpleName();
        if (className.startsWith("Leader")) {
            return "Leader";
        }
        return this.getClass().getSimpleName().substring(3, 6);
    }

    public EncodedValue getCode(String otherCode) {
        for (EncodedValue code : this.codes) {
            if (code.getCode().equals(otherCode)) {
                return code;
            }
            if (!code.isRange() || !code.getRange().isValid(otherCode)) continue;
            return code;
        }
        return null;
    }

    public boolean isHistoricalCode(String inputCode) {
        if (this.historicalCodes != null && !this.historicalCodes.isEmpty()) {
            for (EncodedValue historicalCode : this.historicalCodes) {
                if (!historicalCode.getCode().equals(inputCode)) continue;
                return true;
            }
        }
        return false;
    }

    public String getPath() {
        return this.getPath(true);
    }

    public String getPath(boolean showId) {
        if (showId) {
            return String.format("%s/%s (%s)", this.getControlField(), this.formatPositon(), this.getId());
        }
        return String.format("%s/%s", this.getControlField(), this.formatPositon());
    }

    public boolean hasParser() {
        return this.parser != null;
    }

    public SubfieldContentParser getParser() {
        return this.parser;
    }

    public List<EncodedValue> getHistoricalCodes() {
        return this.historicalCodes;
    }

    public List<FRBRFunction> getFrbrFunctions() {
        return this.functions;
    }

    public String toString() {
        return "ControlfieldPositionDefinition{label='" + this.label + "', positionStart=" + this.positionStart + ", positionEnd=" + this.positionEnd + ", codes=" + this.codes + ", validCodes=" + this.validCodes + ", unitLength=" + this.unitLength + ", repeatableContent=" + this.repeatableContent + ", mqTag=" + this.mqTag + ", id=" + this.id + "}";
    }
}

