/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.general.validator;

import de.gwdg.metadataqa.marc.MarcSubfield;
import de.gwdg.metadataqa.marc.definition.ValidatorResponse;
import de.gwdg.metadataqa.marc.definition.general.validator.SubfieldValidator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import de.gwdg.metadataqa.marc.model.validation.ValidationError;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorType;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class RegexValidator
implements SubfieldValidator,
Serializable {
    private final Pattern pattern;

    public RegexValidator(String rawPattern) {
        this.pattern = Pattern.compile(rawPattern);
    }

    @Override
    public ValidatorResponse isValid(MarcSubfield subfield) {
        Matcher matcher;
        ValidatorResponse response = new ValidatorResponse();
        SubfieldDefinition definition = subfield.getDefinition();
        String descriptionUrl = definition.getParent().getDescriptionUrl();
        String value = subfield.getValue();
        if (StringUtils.isNotBlank(value) && !(matcher = this.pattern.matcher(value)).matches()) {
            response.addValidationError(new ValidationError(subfield.getMarcRecord().getId(), subfield.getDefinition().getPath(), ValidationErrorType.SUBFIELD_PATTERN_MISMATCH, String.format("mismatched '%s' against '%s'", value, this.pattern.pattern()), descriptionUrl));
        }
        return response;
    }
}

