/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.general.validator;

import de.gwdg.metadataqa.marc.MarcSubfield;
import de.gwdg.metadataqa.marc.definition.ValidatorResponse;
import de.gwdg.metadataqa.marc.definition.general.validator.SubfieldValidator;
import de.gwdg.metadataqa.marc.model.validation.ValidationError;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorType;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ISSNValidator
implements SubfieldValidator,
Serializable {
    public static final String URL = "https://en.wikipedia.org/wiki/International_Standard_Serial_Number";
    public static final Pattern ISSN = Pattern.compile("\\d{4}-\\d{3}[\\dxX]");
    public static final String MESSAGE_INTEGRITY = "ISSN failed in integrity check";
    public static final String MESSAGE_PATTERN = "ISSN does not fit the pattern \\d{4}-\\d{3}[\\dX].";
    private static ISSNValidator uniqueInstance;

    private ISSNValidator() {
    }

    public static ISSNValidator getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new ISSNValidator();
        }
        return uniqueInstance;
    }

    @Override
    public ValidatorResponse isValid(MarcSubfield subfield) {
        String value = ISSNValidator.normalize(subfield.getValue());
        ValidatorResponse response = new ValidatorResponse();
        String message = null;
        boolean found = false;
        Matcher matcher = ISSN.matcher(value);
        while (matcher.find()) {
            String checkDigit;
            found = true;
            String match = matcher.group();
            value = match.replace("-", "").toUpperCase();
            int sum = 0;
            for (int i = 0; i < 7; ++i) {
                sum += Integer.parseInt(value.substring(i, i + 1)) * (8 - i);
            }
            int remainder = sum % 11;
            if (remainder > 0) {
                remainder = 11 - remainder;
            }
            if (value.endsWith(checkDigit = remainder == 10 ? "X" : String.valueOf(remainder))) continue;
            message = MESSAGE_INTEGRITY;
            response.addValidationError(new ValidationError(subfield.getField().getMarcRecord().getId(), subfield.getDefinition().getPath(), ValidationErrorType.SUBFIELD_ISSN, message, URL));
        }
        if (!found) {
            message = MESSAGE_PATTERN;
            response.addValidationError(new ValidationError(subfield.getField().getMarcRecord().getId(), subfield.getDefinition().getPath(), ValidationErrorType.SUBFIELD_ISSN, message, URL));
        }
        response.setValid(response.getValidationErrors().isEmpty());
        return response;
    }

    private static String normalize(String value) {
        value = value.replaceAll(" \\(ISSN\\)$", "").replaceAll("[\\s;:-]{1,20}$", "").trim();
        return value;
    }
}

