/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.general.validator;

import de.gwdg.metadataqa.marc.MarcSubfield;
import de.gwdg.metadataqa.marc.dao.DataField;
import de.gwdg.metadataqa.marc.dao.record.BibliographicRecord;
import de.gwdg.metadataqa.marc.definition.ValidatorResponse;
import de.gwdg.metadataqa.marc.definition.general.validator.FieldValidator;
import de.gwdg.metadataqa.marc.definition.general.validator.RecordValidator;
import de.gwdg.metadataqa.marc.model.validation.ValidationError;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorType;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class ClassificationReferenceValidator
implements RecordValidator,
FieldValidator {
    private static final Logger logger = Logger.getLogger(ClassificationReferenceValidator.class.getCanonicalName());
    protected static final List<String> fields = Arrays.asList("016", "024", "041", "047", "048", "052", "072", "600", "610", "611", "630", "647", "648", "650", "651", "655", "656", "657", "852");

    public static ValidatorResponse validate(BibliographicRecord marcRecord) {
        ValidatorResponse response = new ValidatorResponse();
        for (String tag : fields) {
            if (!marcRecord.exists(tag)) continue;
            List<DataField> fields2 = marcRecord.getDatafield(tag);
            for (DataField field : fields2) {
                List<MarcSubfield> subfield2;
                if (!field.getInd2().equals("7") || (subfield2 = field.getSubfield("2")) != null) continue;
                response.addValidationError(new ValidationError(field.getMarcRecord().getId(), field.getTag() + "$ind2", ValidationErrorType.SUBFIELD_INVALID_CLASSIFICATION_REFERENCE, "ind2 is '7' which means that the value should be found in subfield $2, but it is missing", field.getDefinition().getDescriptionUrl()));
            }
        }
        return response;
    }

    public static ValidatorResponse validate(DataField field) {
        List<MarcSubfield> subfield2;
        ValidatorResponse response = new ValidatorResponse();
        if (fields.contains(field.getTag()) && field.getInd2().equals("7") && (subfield2 = field.getSubfield("2")) == null) {
            response.setValid(false);
            response.addValidationError(new ValidationError(field.getMarcRecord().getId(), field.getTag() + "$ind2", ValidationErrorType.SUBFIELD_INVALID_CLASSIFICATION_REFERENCE, "ind2 is '7' which means that the value should be found in subfield $2, but it is missing", field.getDefinition().getDescriptionUrl()));
        }
        return response;
    }
}

