/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.general.parser;

import de.gwdg.metadataqa.marc.definition.general.parser.ParserException;
import de.gwdg.metadataqa.marc.definition.general.parser.SubfieldContentParser;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.HashMap;
import java.util.Map;

public class Control008All00DateParser
implements SubfieldContentParser,
Serializable {
    private String dateFormat = "yyMMdd";
    private DateTimeFormatter marc;
    DateTimeFormatter iso = DateTimeFormatter.ISO_DATE;

    public Control008All00DateParser() {
        this.initialize();
    }

    public Control008All00DateParser(String dateFormat) {
        this.dateFormat = dateFormat;
        this.initialize();
    }

    private void initialize() {
        this.marc = new DateTimeFormatterBuilder().appendValueReduced((TemporalField)ChronoField.YEAR_OF_ERA, 2, 2, LocalDate.now().minusYears(80L)).appendPattern("MMdd").toFormatter();
    }

    @Override
    public Map<String, String> parse(String content) throws ParserException {
        HashMap<String, String> extra = new HashMap<String, String>();
        try {
            LocalDate date = LocalDate.parse(content, this.marc);
            extra.put("normalized", date.format(this.iso));
        }
        catch (DateTimeParseException e) {
            throw new ParserException(String.format("Invalid content: '%s'. %s", content, e.getMessage()));
        }
        return extra;
    }
}

